/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.testsummary;

import org.eclipse.edc.plugins.testsummary.SummaryPrinterAdapter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;

public class TestSummaryPlugin
implements Plugin<Project> {
    public void apply(Project target) {
        Task testTasks = target.getTasks().getByName("test");
        if (testTasks instanceof Test) {
            ((Test)testTasks).addTestListener((TestListener)new AfterSuitePrinter(target.getLogger()));
        }
    }

    private static class AfterSuitePrinter
    extends SummaryPrinterAdapter {
        private final Logger logger;

        AfterSuitePrinter(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void afterSuite(TestDescriptor suite, TestResult result) {
            if (suite.getParent() == null) {
                String output = String.format("Results: %s (%d tests, %d passed, %d failed, %d skipped)", result.getResultType().toString(), result.getTestCount(), result.getSuccessfulTestCount(), result.getFailedTestCount(), result.getSkippedTestCount());
                String startItem = "|  ";
                String endItem = "  |";
                int repeatLength = startItem.length() + output.length() + endItem.length();
                this.logger.lifecycle(String.format("\n%s\n%s%s%s\n%s%n", "-".repeat(repeatLength), startItem, output, endItem, "-".repeat(repeatLength)));
            }
        }
    }
}

