/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.iam.identitytrust.sts.model;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import jakarta.ws.rs.FormParam;

public final class StsTokenRequest {
    @Parameter(name="grant_type", description="Type of grant: must be set to client_credentials", required=true, style=ParameterStyle.FORM)
    @FormParam(value="grant_type")
    private String grantType;
    @Parameter(name="client_id", description="Id of the client requesting an SI token", required=true, style=ParameterStyle.FORM)
    @FormParam(value="client_id")
    private String clientId;
    @Parameter(name="audience", description="Audience for the SI token", required=true, style=ParameterStyle.FORM)
    @FormParam(value="audience")
    private String audience;
    @Parameter(name="bearer_access_scope", description="Scope to be added in the VP token", style=ParameterStyle.FORM)
    @FormParam(value="bearer_access_scope")
    private String bearerAccessScope;
    @Parameter(name="token", description="VP token to be added as a claim in the SI token", style=ParameterStyle.FORM)
    @FormParam(value="token")
    private String token;
    @Parameter(name="client_secret", description="Secret of the client requesting an SI token", required=true, style=ParameterStyle.FORM)
    @FormParam(value="client_secret")
    private String clientSecret;

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getBearerAccessScope() {
        return this.bearerAccessScope;
    }

    public String getToken() {
        return this.token;
    }

    public static class Builder {
        private final StsTokenRequest request;

        protected Builder(StsTokenRequest request) {
            this.request = request;
        }

        public static Builder newInstance() {
            return new Builder(new StsTokenRequest());
        }

        public Builder grantType(String grantType) {
            this.request.grantType = grantType;
            return this;
        }

        public Builder clientId(String clientId) {
            this.request.clientId = clientId;
            return this;
        }

        public Builder audience(String audience) {
            this.request.audience = audience;
            return this;
        }

        public Builder bearerAccessScope(String bearerAccessScope) {
            this.request.bearerAccessScope = bearerAccessScope;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.request.token = accessToken;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.request.clientSecret = clientSecret;
            return this;
        }

        public StsTokenRequest build() {
            return this.request;
        }
    }
}

