/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.iam.identitytrust.sts.exception;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.Map;
import org.eclipse.edc.api.iam.identitytrust.sts.exception.StsTokenException;
import org.eclipse.edc.api.iam.identitytrust.sts.model.StsTokenErrorResponse;
import org.eclipse.edc.spi.result.ServiceFailure;

public class StsTokenExceptionMapper
implements ExceptionMapper<StsTokenException> {
    private static final Map<ServiceFailure.Reason, Response.Status> STATUS_MAP = Map.of(ServiceFailure.Reason.UNAUTHORIZED, Response.Status.UNAUTHORIZED, ServiceFailure.Reason.NOT_FOUND, Response.Status.UNAUTHORIZED, ServiceFailure.Reason.BAD_REQUEST, Response.Status.BAD_REQUEST, ServiceFailure.Reason.CONFLICT, Response.Status.BAD_REQUEST);
    private static final Map<ServiceFailure.Reason, String> ERRORS_MAP = Map.of(ServiceFailure.Reason.UNAUTHORIZED, "invalid_client", ServiceFailure.Reason.NOT_FOUND, "invalid_client", ServiceFailure.Reason.BAD_REQUEST, "invalid_request", ServiceFailure.Reason.CONFLICT, "invalid_request");
    private static final Map<ServiceFailure.Reason, String> ERROR_DETAILS_MAP = Map.of(ServiceFailure.Reason.UNAUTHORIZED, "Invalid client or Invalid client credentials", ServiceFailure.Reason.NOT_FOUND, "Invalid client or Invalid client credentials");

    public Response toResponse(StsTokenException exception) {
        ServiceFailure failure = exception.getServiceFailure();
        Response.Status status = STATUS_MAP.getOrDefault(failure.getReason(), Response.Status.INTERNAL_SERVER_ERROR);
        String errorDescription = ERROR_DETAILS_MAP.getOrDefault(failure.getReason(), exception.getMessage());
        String errorCode = ERRORS_MAP.getOrDefault(failure.getReason(), "invalid_request");
        StsTokenErrorResponse error = new StsTokenErrorResponse(errorCode, errorDescription);
        return Response.status((Response.Status)status).entity((Object)error).build();
    }
}

