/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.iam.identitytrust.sts.exception;

import java.util.function.Function;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.eclipse.edc.validator.spi.ValidationFailure;
import org.jetbrains.annotations.Nullable;

public class StsTokenException
extends EdcException {
    private final ServiceFailure serviceFailure;
    private final String clientId;

    public StsTokenException(ServiceFailure serviceFailure, String clientId) {
        super(serviceFailure.getFailureDetail());
        this.serviceFailure = serviceFailure;
        this.clientId = clientId;
    }

    public static Function<ServiceFailure, StsTokenException> tokenException(@Nullable String clientId) {
        return serviceFailure -> new StsTokenException((ServiceFailure)serviceFailure, clientId);
    }

    public static Function<ValidationFailure, StsTokenException> validationException(@Nullable String clientId) {
        return failure -> new StsTokenException(new ServiceFailure(failure.getMessages(), ServiceFailure.Reason.BAD_REQUEST), clientId);
    }

    public ServiceFailure getServiceFailure() {
        return this.serviceFailure;
    }

    public String getClientId() {
        return this.clientId;
    }
}

