/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.iam.identitytrust.sts.controller;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.api.iam.identitytrust.sts.SecureTokenServiceApi;
import org.eclipse.edc.api.iam.identitytrust.sts.exception.StsTokenException;
import org.eclipse.edc.api.iam.identitytrust.sts.model.StsTokenRequest;
import org.eclipse.edc.api.iam.identitytrust.sts.model.StsTokenResponse;
import org.eclipse.edc.iam.identitytrust.sts.spi.model.StsAccountTokenAdditionalParams;
import org.eclipse.edc.iam.identitytrust.sts.spi.service.StsAccountService;
import org.eclipse.edc.iam.identitytrust.sts.spi.service.StsClientTokenGeneratorService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.validator.spi.Validator;

@Path(value="/")
public class SecureTokenServiceApiController
implements SecureTokenServiceApi {
    private final StsAccountService clientService;
    private final StsClientTokenGeneratorService tokenService;
    private final Validator<StsTokenRequest> tokenRequestValidator;

    public SecureTokenServiceApiController(StsAccountService clientService, StsClientTokenGeneratorService tokenService, Validator<StsTokenRequest> tokenRequestValidator) {
        this.clientService = clientService;
        this.tokenService = tokenService;
        this.tokenRequestValidator = tokenRequestValidator;
    }

    @Override
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="token")
    @POST
    public StsTokenResponse token(@BeanParam StsTokenRequest request) {
        this.tokenRequestValidator.validate((Object)request).orElseThrow(StsTokenException.validationException(request.getClientId()));
        return (StsTokenResponse)((ServiceResult)((ServiceResult)this.clientService.findByClientId(request.getClientId()).compose(client -> this.clientService.authenticate(client, request.getClientSecret()))).compose(client -> this.tokenService.tokenFor(client, this.additionalParams(request)))).map(this::mapToken).orElseThrow(StsTokenException.tokenException(request.getClientId()));
    }

    private StsAccountTokenAdditionalParams additionalParams(StsTokenRequest request) {
        return StsAccountTokenAdditionalParams.Builder.newInstance().audience(request.getAudience()).accessToken(request.getToken()).bearerAccessScope(request.getBearerAccessScope()).build();
    }

    private StsTokenResponse mapToken(TokenRepresentation tokenRepresentation) {
        return new StsTokenResponse(tokenRepresentation.getToken(), tokenRepresentation.getExpiresIn());
    }
}

