/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.iam.identitytrust.sts;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.configuration.PortMapping;
import org.eclipse.edc.web.spi.configuration.PortMappingRegistry;

@Extension(value="Secure Token Service API configuration")
public class StsApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Secure Token Service API configuration";
    static final int DEFAULT_STS_PORT = 9292;
    static final String DEFAULT_STS_PATH = "/api/sts";
    private static final String API_VERSION_JSON_FILE = "sts-api-version.json";
    @Configuration
    private StsApiConfiguration apiConfiguration;
    @Inject
    private PortMappingRegistry portMappingRegistry;
    @Inject
    private TypeManager typeManager;
    @Inject
    private ApiVersionService apiVersionService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.portMappingRegistry.register(new PortMapping("sts", this.apiConfiguration.port(), this.apiConfiguration.path()));
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("sts", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    @Settings
    record StsApiConfiguration(@Setting(key="web.http.sts.port", description="Port for sts api context", defaultValue="9292") int port, @Setting(key="web.http.sts.path", description="Path for sts api context", defaultValue="/api/sts") String path) {
    }
}

