/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.sql.ConnectionFactory;
import org.eclipse.edc.sql.datasource.ConnectionFactoryDataSource;
import org.eclipse.edc.sql.datasource.ConnectionPoolDataSource;
import org.eclipse.edc.sql.pool.ConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPoolConfig;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Extension(value="Commons Connection Pool")
public class CommonsConnectionPoolServiceExtension
implements ServiceExtension {
    public static final String NAME = "Commons Connection Pool";
    public static final String EDC_DATASOURCE_PREFIX = "edc.datasource";
    public static final String POOL_CONNECTIONS_MAX_IDLE = "pool.connections.max-idle";
    public static final String POOL_CONNECTIONS_MAX_TOTAL = "pool.connections.max-total";
    public static final String POOL_CONNECTIONS_MIN_IDLE = "pool.connections.min-idle";
    public static final String POOL_CONNECTION_TEST_ON_BORROW = "pool.connection.test.on-borrow";
    public static final String POOL_CONNECTION_TEST_ON_CREATE = "pool.connection.test.on-create";
    public static final String POOL_CONNECTION_TEST_ON_RETURN = "pool.connection.test.on-return";
    public static final String POOL_CONNECTION_TEST_WHILE_IDLE = "pool.connection.test.while-idle";
    public static final String POOL_CONNECTION_TEST_QUERY = "pool.connection.test.query";
    @Setting(required=true)
    public static final String URL = "url";
    @Setting(value="Username to be used for the JDBC connection. Can be omitted if not required, or if the user is encoded in the JDBC url.")
    public static final String USER = "user";
    @Setting(value="Username to be used for the JDBC connection. Can be omitted if not required, or if the password is encoded in the JDBC url.")
    public static final String PASSWORD = "password";
    private final List<CommonsConnectionPool> commonsConnectionPools = new LinkedList<CommonsConnectionPool>();
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private ConnectionFactory connectionFactory;
    @Inject
    private Vault vault;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Config config = context.getConfig(EDC_DATASOURCE_PREFIX);
        Map<String, CommonsConnectionPool> namedConnectionPools = this.createConnectionPools(config);
        for (Map.Entry<String, CommonsConnectionPool> entry : namedConnectionPools.entrySet()) {
            String dataSourceName = entry.getKey();
            CommonsConnectionPool commonsConnectionPool = entry.getValue();
            this.commonsConnectionPools.add(commonsConnectionPool);
            ConnectionPoolDataSource connectionPoolDataSource = new ConnectionPoolDataSource((ConnectionPool)commonsConnectionPool);
            this.dataSourceRegistry.register(dataSourceName, (DataSource)connectionPoolDataSource);
        }
    }

    public void shutdown() {
        this.commonsConnectionPools.forEach(CommonsConnectionPool::close);
    }

    public List<CommonsConnectionPool> getCommonsConnectionPools() {
        return this.commonsConnectionPools;
    }

    private @NotNull Supplier<@Nullable String> readFromConfig(Config config, String value) {
        return () -> {
            String entry = "edc.datasource." + config.currentNode() + "." + value;
            this.monitor.warning("Database configuration value '%s' not found in vault, will fall back to Config. Please consider putting database configuration into the vault.".formatted(entry), new Throwable[0]);
            return config.getString(value, null);
        };
    }

    private void setIfProvidedString(String key, Consumer<String> setter, Config config) {
        this.setIfProvided(key, setter, (arg_0, arg_1) -> ((Config)config).getString(arg_0, arg_1));
    }

    private void setIfProvidedBoolean(String key, Consumer<Boolean> setter, Config config) {
        this.setIfProvided(key, setter, (arg_0, arg_1) -> ((Config)config).getBoolean(arg_0, arg_1));
    }

    private void setIfProvidedInt(String key, Consumer<Integer> setter, Config config) {
        this.setIfProvided(key, setter, (arg_0, arg_1) -> ((Config)config).getInteger(arg_0, arg_1));
    }

    private <T> void setIfProvided(String key, Consumer<T> setter, BiFunction<String, T, T> getter) {
        T value = getter.apply(key, null);
        if (value != null) {
            setter.accept(value);
        }
    }

    private Map<String, CommonsConnectionPool> createConnectionPools(Config parent) {
        HashMap<String, CommonsConnectionPool> commonsConnectionPools = new HashMap<String, CommonsConnectionPool>();
        for (Config config : parent.partition().toList()) {
            String dataSourceName = config.currentNode();
            DataSource dataSource = this.createDataSource(config);
            CommonsConnectionPool commonsConnectionPool = this.createConnectionPool(dataSource, config);
            commonsConnectionPools.put(dataSourceName, commonsConnectionPool);
        }
        return commonsConnectionPools;
    }

    private DataSource createDataSource(Config config) {
        String rootPath = "edc.datasource." + config.currentNode();
        String urlProperty = rootPath + ".url";
        String jdbcUrl = Optional.ofNullable(this.vault.resolveSecret(urlProperty)).orElseGet(this.readFromConfig(config, URL));
        if (jdbcUrl == null) {
            throw new EdcException("Mandatory config '%s' not found. Please provide a value for the '%s' property, either as a secret in the vault or an application property.".formatted(urlProperty, urlProperty));
        }
        String jdbcUser = Optional.ofNullable(this.vault.resolveSecret(rootPath + ".user")).orElseGet(this.readFromConfig(config, USER));
        String jdbcPassword = Optional.ofNullable(this.vault.resolveSecret(rootPath + ".password")).orElseGet(this.readFromConfig(config, PASSWORD));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)config.getRelativeEntries());
        Optional.ofNullable(jdbcUser).ifPresent(u -> properties.put(USER, u));
        Optional.ofNullable(jdbcPassword).ifPresent(p -> properties.put(PASSWORD, p));
        return new ConnectionFactoryDataSource(this.connectionFactory, jdbcUrl, properties);
    }

    private CommonsConnectionPool createConnectionPool(DataSource unPooledDataSource, Config config) {
        CommonsConnectionPoolConfig.Builder builder = CommonsConnectionPoolConfig.Builder.newInstance();
        this.setIfProvidedInt(POOL_CONNECTIONS_MAX_IDLE, builder::maxIdleConnections, config);
        this.setIfProvidedInt(POOL_CONNECTIONS_MAX_TOTAL, builder::maxTotalConnections, config);
        this.setIfProvidedInt(POOL_CONNECTIONS_MIN_IDLE, builder::minIdleConnections, config);
        this.setIfProvidedBoolean(POOL_CONNECTION_TEST_ON_BORROW, builder::testConnectionOnBorrow, config);
        this.setIfProvidedBoolean(POOL_CONNECTION_TEST_ON_CREATE, builder::testConnectionOnCreate, config);
        this.setIfProvidedBoolean(POOL_CONNECTION_TEST_ON_RETURN, builder::testConnectionOnReturn, config);
        this.setIfProvidedBoolean(POOL_CONNECTION_TEST_WHILE_IDLE, builder::testConnectionWhileIdle, config);
        this.setIfProvidedString(POOL_CONNECTION_TEST_QUERY, builder::testQuery, config);
        return new CommonsConnectionPool(unPooledDataSource, builder.build(), this.monitor);
    }
}

