/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CommonsConnectionPoolConfig {
    private final int maxIdleConnections;
    private final int maxTotalConnections;
    private final int minIdleConnections;
    private final boolean testConnectionOnBorrow;
    private final boolean testConnectionOnCreate;
    private final boolean testConnectionOnReturn;
    private final boolean testConnectionWhileIdle;
    private final String testQuery;

    private CommonsConnectionPoolConfig(int maxIdleConnections, int maxTotalConnections, int minIdleConnections, boolean testConnectionOnBorrow, boolean testConnectionOnCreate, boolean testConnectionOnReturn, boolean testConnectionWhileIdle, @NotNull String testQuery) {
        this.maxIdleConnections = maxIdleConnections;
        this.maxTotalConnections = maxTotalConnections;
        this.minIdleConnections = minIdleConnections;
        this.testConnectionOnBorrow = testConnectionOnBorrow;
        this.testConnectionOnCreate = testConnectionOnCreate;
        this.testConnectionOnReturn = testConnectionOnReturn;
        this.testConnectionWhileIdle = testConnectionWhileIdle;
        this.testQuery = Objects.requireNonNull(testQuery);
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public boolean getTestConnectionOnBorrow() {
        return this.testConnectionOnBorrow;
    }

    public boolean getTestConnectionOnCreate() {
        return this.testConnectionOnCreate;
    }

    public boolean getTestConnectionOnReturn() {
        return this.testConnectionOnReturn;
    }

    public boolean getTestConnectionWhileIdle() {
        return this.testConnectionWhileIdle;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public static final class Builder {
        private int maxIdleConnections = 4;
        private int maxTotalConnections = 8;
        private int minIdleConnections = 1;
        private boolean testConnectionOnBorrow = true;
        private boolean testConnectionOnCreate = true;
        private boolean testConnectionOnReturn = false;
        private boolean testConnectionWhileIdle = false;
        private String testQuery = "SELECT 1;";

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Builder maxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder minIdleConnections(int minIdleConnections) {
            this.minIdleConnections = minIdleConnections;
            return this;
        }

        public Builder testConnectionOnBorrow(boolean testConnectionOnBorrow) {
            this.testConnectionOnBorrow = testConnectionOnBorrow;
            return this;
        }

        public Builder testConnectionOnCreate(boolean testConnectionOnCreate) {
            this.testConnectionOnCreate = testConnectionOnCreate;
            return this;
        }

        public Builder testConnectionOnReturn(boolean testConnectionOnReturn) {
            this.testConnectionOnReturn = testConnectionOnReturn;
            return this;
        }

        public Builder testConnectionWhileIdle(boolean testConnectionWhileIdle) {
            this.testConnectionWhileIdle = testConnectionWhileIdle;
            return this;
        }

        public Builder testQuery(String testQuery) {
            this.testQuery = testQuery;
            return this;
        }

        public CommonsConnectionPoolConfig build() {
            return new CommonsConnectionPoolConfig(this.maxIdleConnections, this.maxTotalConnections, this.minIdleConnections, this.testConnectionOnBorrow, this.testConnectionOnCreate, this.testConnectionOnReturn, this.testConnectionWhileIdle, this.testQuery);
        }
    }
}

