/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.sql.ConnectionFactory;

public class DriverManagerConnectionFactory
implements ConnectionFactory {
    private final String jdbcUrl;
    private final Properties properties;

    public DriverManagerConnectionFactory(String jdbcUrl, Properties properties) {
        this.jdbcUrl = Objects.requireNonNull(jdbcUrl);
        this.properties = Objects.requireNonNull(properties);
    }

    public Connection create() {
        try {
            return DriverManager.getConnection(this.jdbcUrl, this.properties);
        }
        catch (Exception exception) {
            throw new EdcPersistenceException(exception.getMessage(), (Throwable)exception);
        }
    }
}

