/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.sql.ConnectionFactory;
import org.eclipse.edc.sql.datasource.ConnectionFactoryDataSource;
import org.eclipse.edc.sql.datasource.ConnectionPoolDataSource;
import org.eclipse.edc.sql.pool.ConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPoolConfig;
import org.eclipse.edc.sql.pool.commons.DriverManagerConnectionFactory;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;

@Extension(value="Commons Connection Pool")
public class CommonsConnectionPoolServiceExtension
implements ServiceExtension {
    public static final String NAME = "Commons Connection Pool";
    static final String EDC_DATASOURCE_PREFIX = "edc.datasource";
    private final List<CommonsConnectionPool> commonsConnectionPools = new LinkedList<CommonsConnectionPool>();
    @Inject
    private DataSourceRegistry dataSourceRegistry;

    private static void setIfProvidedString(String key, Consumer<String> setter, Config config) {
        String value = config.getString(key, null);
        if (value == null) {
            return;
        }
        setter.accept(value);
    }

    private static void setIfProvidedInt(String key, Consumer<Integer> setter, Config config) {
        Integer value = config.getInteger(key, null);
        if (value == null) {
            return;
        }
        setter.accept(value);
    }

    private static void setIfProvidedBoolean(String key, Consumer<Boolean> setter, Config config) {
        String value = config.getString(key, null);
        if (value == null) {
            return;
        }
        setter.accept(Boolean.parseBoolean(value));
    }

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Config config = context.getConfig(EDC_DATASOURCE_PREFIX);
        Map<String, CommonsConnectionPool> namedConnectionPools = this.createConnectionPools(config);
        for (Map.Entry<String, CommonsConnectionPool> entry : namedConnectionPools.entrySet()) {
            String dataSourceName = entry.getKey();
            CommonsConnectionPool commonsConnectionPool = entry.getValue();
            this.commonsConnectionPools.add(commonsConnectionPool);
            ConnectionPoolDataSource connectionPoolDataSource = new ConnectionPoolDataSource((ConnectionPool)commonsConnectionPool);
            this.dataSourceRegistry.register(dataSourceName, (DataSource)connectionPoolDataSource);
        }
    }

    public void shutdown() {
        for (CommonsConnectionPool commonsConnectionPool : this.commonsConnectionPools) {
            commonsConnectionPool.close();
        }
    }

    private Map<String, CommonsConnectionPool> createConnectionPools(Config parent) {
        HashMap<String, CommonsConnectionPool> commonsConnectionPools = new HashMap<String, CommonsConnectionPool>();
        for (Config config : parent.partition().collect(Collectors.toList())) {
            String dataSourceName = config.currentNode();
            DataSource dataSource = this.createDataSource(config);
            CommonsConnectionPool commonsConnectionPool = this.createConnectionPool(dataSource, config);
            commonsConnectionPools.put(dataSourceName, commonsConnectionPool);
        }
        return commonsConnectionPools;
    }

    private DataSource createDataSource(Config config) {
        String jdbcUrl = Objects.requireNonNull(config.getString("url"));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)config.getRelativeEntries());
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcUrl, properties);
        return new ConnectionFactoryDataSource((ConnectionFactory)connectionFactory);
    }

    private CommonsConnectionPool createConnectionPool(DataSource unPooledDataSource, Config config) {
        CommonsConnectionPoolConfig.Builder builder = CommonsConnectionPoolConfig.Builder.newInstance();
        CommonsConnectionPoolServiceExtension.setIfProvidedInt("pool.maxIdleConnections", builder::maxIdleConnections, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedInt("pool.maxTotalConnections", builder::maxTotalConnections, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedInt("pool.minIdleConnections", builder::minIdleConnections, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedBoolean("pool.testConnectionOnBorrow", builder::testConnectionOnBorrow, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedBoolean("pool.testConnectionOnCreate", builder::testConnectionOnCreate, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedBoolean("pool.testConnectionOnReturn", builder::testConnectionOnReturn, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedBoolean("pool.testConnectionWhileIdle", builder::testConnectionWhileIdle, config);
        CommonsConnectionPoolServiceExtension.setIfProvidedString("pool.testQuery", builder::testQuery, config);
        return new CommonsConnectionPool(unPooledDataSource, builder.build());
    }
}

