/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.sql.pool.ConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPoolConfig;
import org.jetbrains.annotations.NotNull;

public final class CommonsConnectionPool
implements ConnectionPool,
AutoCloseable {
    private final GenericObjectPool<Connection> connectionObjectPool;
    private final CommonsConnectionPoolConfig poolConfig;

    public CommonsConnectionPool(DataSource dataSource, CommonsConnectionPoolConfig commonsConnectionPoolConfig, Monitor monitor) {
        this.poolConfig = commonsConnectionPoolConfig;
        Objects.requireNonNull(dataSource, "connectionFactory");
        Objects.requireNonNull(commonsConnectionPoolConfig, "commonsConnectionPoolConfig");
        this.connectionObjectPool = new GenericObjectPool((PooledObjectFactory)new PooledConnectionObjectFactory(dataSource, commonsConnectionPoolConfig.getTestQuery(), monitor), CommonsConnectionPool.getGenericObjectPoolConfig(commonsConnectionPoolConfig));
    }

    private static GenericObjectPoolConfig<Connection> getGenericObjectPoolConfig(CommonsConnectionPoolConfig commonsConnectionPoolConfig) {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setJmxEnabled(false);
        genericObjectPoolConfig.setMaxIdle(commonsConnectionPoolConfig.getMaxIdleConnections());
        genericObjectPoolConfig.setMaxTotal(commonsConnectionPoolConfig.getMaxTotalConnections());
        genericObjectPoolConfig.setMinIdle(commonsConnectionPoolConfig.getMinIdleConnections());
        genericObjectPoolConfig.setTestOnBorrow(commonsConnectionPoolConfig.getTestConnectionOnBorrow());
        genericObjectPoolConfig.setTestOnCreate(commonsConnectionPoolConfig.getTestConnectionOnCreate());
        genericObjectPoolConfig.setTestOnReturn(commonsConnectionPoolConfig.getTestConnectionOnReturn());
        genericObjectPoolConfig.setTestWhileIdle(commonsConnectionPoolConfig.getTestConnectionWhileIdle());
        return genericObjectPoolConfig;
    }

    public Connection getConnection() {
        try {
            return (Connection)this.connectionObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public void returnConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection");
        this.connectionObjectPool.returnObject((Object)connection);
    }

    @Override
    public void close() {
        this.connectionObjectPool.close();
    }

    public CommonsConnectionPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    private static class PooledConnectionObjectFactory
    extends BasePooledObjectFactory<Connection> {
        private final String testQuery;
        private final DataSource dataSource;
        private final Monitor monitor;

        PooledConnectionObjectFactory(@NotNull DataSource dataSource, @NotNull String testQuery, Monitor monitor) {
            this.dataSource = Objects.requireNonNull(dataSource);
            this.testQuery = Objects.requireNonNull(testQuery);
            this.monitor = monitor;
        }

        public Connection create() throws SQLException {
            return this.dataSource.getConnection();
        }

        public boolean validateObject(PooledObject<Connection> pooledObject) {
            if (pooledObject == null) {
                return false;
            }
            Connection connection = (Connection)pooledObject.getObject();
            if (connection == null) {
                return false;
            }
            return this.isConnectionValid(connection);
        }

        public PooledObject<Connection> wrap(Connection connection) {
            return new DefaultPooledObject((Object)connection);
        }

        public void destroyObject(PooledObject<Connection> pooledObject, DestroyMode destroyMode) throws Exception {
            if (pooledObject == null) {
                return;
            }
            Connection connection = (Connection)pooledObject.getObject();
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
            pooledObject.invalidate();
        }

        private boolean isConnectionValid(Connection connection) {
            boolean bl;
            block9: {
                if (connection.isClosed()) {
                    return false;
                }
                PreparedStatement preparedStatement = connection.prepareStatement(this.testQuery);
                try {
                    preparedStatement.execute();
                    bl = this.rollbackIfNeeded(connection);
                    if (preparedStatement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                preparedStatement.close();
            }
            return bl;
        }

        private boolean rollbackIfNeeded(Connection connection) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
                return true;
            }
            catch (SQLException e) {
                this.monitor.debug("Failed to rollback transaction", new Throwable[]{e});
                return false;
            }
        }
    }
}

