/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.pool.commons;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.sql.ConnectionFactory;
import org.eclipse.edc.sql.datasource.ConnectionFactoryDataSource;
import org.eclipse.edc.sql.datasource.ConnectionPoolDataSource;
import org.eclipse.edc.sql.pool.ConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPool;
import org.eclipse.edc.sql.pool.commons.CommonsConnectionPoolConfig;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;

@Extension(value="Commons Connection Pool")
public class CommonsConnectionPoolServiceExtension
implements ServiceExtension {
    public static final String NAME = "Commons Connection Pool";
    public static final String EDC_DATASOURCE_PREFIX = "edc.datasource";
    private static final String EDC_DATASOURCE_CONFIG_CONTEXT = "edc.datasource.<name>";
    @Setting(value="JDBC url", required=true, context="edc.datasource.<name>")
    public static final String URL = "url";
    @Setting(value="Username to be used for the JDBC connection. Can be omitted if not required, or if the user is encoded in the JDBC url.", context="edc.datasource.<name>")
    public static final String USER = "user";
    @Setting(value="Username to be used for the JDBC connection. Can be omitted if not required, or if the password is encoded in the JDBC url.", context="edc.datasource.<name>")
    public static final String PASSWORD = "password";
    @Setting(value="Pool max idle connections", type="int", context="edc.datasource.<name>")
    public static final String POOL_CONNECTIONS_MAX_IDLE = "pool.connections.max-idle";
    @Setting(value="Pool max total connections", type="int", context="edc.datasource.<name>")
    public static final String POOL_CONNECTIONS_MAX_TOTAL = "pool.connections.max-total";
    @Setting(value="Pool min idle connections", type="int", context="edc.datasource.<name>")
    public static final String POOL_CONNECTIONS_MIN_IDLE = "pool.connections.min-idle";
    @Setting(value="Pool test on borrow", type="boolean", context="edc.datasource.<name>")
    public static final String POOL_CONNECTION_TEST_ON_BORROW = "pool.connection.test.on-borrow";
    @Setting(value="Pool test on create", type="boolean", context="edc.datasource.<name>")
    public static final String POOL_CONNECTION_TEST_ON_CREATE = "pool.connection.test.on-create";
    @Setting(value="Pool test on return", type="boolean", context="edc.datasource.<name>")
    public static final String POOL_CONNECTION_TEST_ON_RETURN = "pool.connection.test.on-return";
    @Setting(value="Pool test while idle", type="boolean", context="edc.datasource.<name>")
    public static final String POOL_CONNECTION_TEST_WHILE_IDLE = "pool.connection.test.while-idle";
    @Setting(value="Pool test query", context="edc.datasource.<name>")
    public static final String POOL_CONNECTION_TEST_QUERY = "pool.connection.test.query";
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private ConnectionFactory connectionFactory;
    @Inject
    private Vault vault;
    private final List<CommonsConnectionPool> commonsConnectionPools = new LinkedList<CommonsConnectionPool>();

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        context.getConfig(EDC_DATASOURCE_PREFIX).partition().forEach(config -> {
            String dataSourceName = config.currentNode();
            DataSource dataSource = this.createDataSource((Config)config);
            CommonsConnectionPool connectionPool = this.createConnectionPool(dataSource, (Config)config);
            this.commonsConnectionPools.add(connectionPool);
            ConnectionPoolDataSource connectionPoolDataSource = new ConnectionPoolDataSource((ConnectionPool)connectionPool);
            this.dataSourceRegistry.register(dataSourceName, (DataSource)connectionPoolDataSource);
        });
    }

    public void shutdown() {
        this.commonsConnectionPools.forEach(CommonsConnectionPool::close);
    }

    private DataSource createDataSource(Config config) {
        String rootPath = "edc.datasource." + config.currentNode();
        String jdbcUrl = this.getSecretOrSetting(rootPath, URL, config).orElseThrow(() -> new EdcException("Mandatory url for datasource '%s' not found. Please provide a value for it, either as a secret in the vault or an application property.".formatted(config.currentNode())));
        Optional<String> jdbcUser = this.getSecretOrSetting(rootPath, USER, config);
        Optional<String> jdbcPassword = this.getSecretOrSetting(rootPath, PASSWORD, config);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)config.getRelativeEntries());
        jdbcUser.ifPresent(u -> properties.put(USER, u));
        jdbcPassword.ifPresent(p -> properties.put(PASSWORD, p));
        return new ConnectionFactoryDataSource(this.connectionFactory, jdbcUrl, properties);
    }

    private Optional<String> getSecretOrSetting(String rootPath, String key, Config config) {
        String fullKey = rootPath + "." + key;
        return Optional.ofNullable(this.vault.resolveSecret(fullKey)).or(() -> {
            this.monitor.warning("Datasource configuration value '%s' not found in vault, will fall back to Config. Please consider putting datasource configuration into the vault.".formatted(fullKey), new Throwable[0]);
            return Optional.ofNullable(config.getString(key, null));
        });
    }

    private CommonsConnectionPool createConnectionPool(DataSource unPooledDataSource, Config config) {
        CommonsConnectionPoolConfig.Builder builder = CommonsConnectionPoolConfig.Builder.newInstance();
        this.setIfProvided(POOL_CONNECTIONS_MAX_IDLE, (arg_0, arg_1) -> ((Config)config).getInteger(arg_0, arg_1), builder::maxIdleConnections);
        this.setIfProvided(POOL_CONNECTIONS_MAX_TOTAL, (arg_0, arg_1) -> ((Config)config).getInteger(arg_0, arg_1), builder::maxTotalConnections);
        this.setIfProvided(POOL_CONNECTIONS_MIN_IDLE, (arg_0, arg_1) -> ((Config)config).getInteger(arg_0, arg_1), builder::minIdleConnections);
        this.setIfProvided(POOL_CONNECTION_TEST_ON_BORROW, (arg_0, arg_1) -> ((Config)config).getBoolean(arg_0, arg_1), builder::testConnectionOnBorrow);
        this.setIfProvided(POOL_CONNECTION_TEST_ON_CREATE, (arg_0, arg_1) -> ((Config)config).getBoolean(arg_0, arg_1), builder::testConnectionOnCreate);
        this.setIfProvided(POOL_CONNECTION_TEST_ON_RETURN, (arg_0, arg_1) -> ((Config)config).getBoolean(arg_0, arg_1), builder::testConnectionOnReturn);
        this.setIfProvided(POOL_CONNECTION_TEST_WHILE_IDLE, (arg_0, arg_1) -> ((Config)config).getBoolean(arg_0, arg_1), builder::testConnectionWhileIdle);
        this.setIfProvided(POOL_CONNECTION_TEST_QUERY, (arg_0, arg_1) -> ((Config)config).getString(arg_0, arg_1), builder::testQuery);
        return new CommonsConnectionPool(unPooledDataSource, builder.build(), this.monitor);
    }

    private <T> void setIfProvided(String key, BiFunction<String, T, T> getter, Consumer<T> setter) {
        T value = getter.apply(key, null);
        if (value != null) {
            setter.accept(value);
        }
    }
}

