/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.translation.FieldTranslator;
import org.eclipse.edc.sql.translation.PlainColumnFieldTranslator;
import org.eclipse.edc.sql.translation.SqlOperator;
import org.eclipse.edc.sql.translation.WhereClause;
import org.eclipse.edc.util.reflection.PathItem;

public abstract class TranslationMapping {
    private final Map<String, Object> fieldMap = new HashMap<String, Object>();

    public Function<Class<?>, String> getFieldTranslator(String fieldPath) {
        return this.getFieldTranslator(PathItem.parse((String)fieldPath));
    }

    public WhereClause getWhereClause(Criterion criterion, SqlOperator operator) {
        List path = PathItem.parse((String)criterion.getOperandLeft().toString());
        return this.getWhereClause(path, criterion, operator);
    }

    protected void add(String fieldPath, String columnName) {
        this.fieldMap.put(fieldPath, new PlainColumnFieldTranslator(columnName));
    }

    protected void add(String fieldPath, FieldTranslator fieldTranslator) {
        this.fieldMap.put(fieldPath, fieldTranslator);
    }

    protected void add(String fieldPath, TranslationMapping translationMapping) {
        this.fieldMap.put(fieldPath, translationMapping);
    }

    private Function<Class<?>, String> getFieldTranslator(List<PathItem> path) {
        Object entry = this.fieldMap.get(path.get(0).toString());
        if (entry == null) {
            return null;
        }
        List<PathItem> nestedPath = path.stream().skip(1L).toList();
        if (entry instanceof FieldTranslator) {
            FieldTranslator fieldTranslator = (FieldTranslator)entry;
            return clazz -> fieldTranslator.getLeftOperand(nestedPath, (Class<?>)clazz);
        }
        if (entry instanceof TranslationMapping) {
            TranslationMapping mappingEntry = (TranslationMapping)entry;
            return mappingEntry.getFieldTranslator(nestedPath);
        }
        throw new IllegalArgumentException("unexpected mapping");
    }

    private WhereClause getWhereClause(List<PathItem> path, Criterion criterion, SqlOperator operator) {
        Object entry = this.fieldMap.get(path.get(0).toString());
        if (entry == null) {
            return null;
        }
        if (entry instanceof FieldTranslator) {
            FieldTranslator fieldTranslator = (FieldTranslator)entry;
            List<PathItem> nestedPath = path.size() == 1 ? path : path.stream().skip(1L).toList();
            return fieldTranslator.toWhereClause(nestedPath, criterion, operator);
        }
        if (entry instanceof TranslationMapping) {
            TranslationMapping mappingEntry = (TranslationMapping)entry;
            List<PathItem> nestedPath = path.stream().skip(1L).toList();
            return mappingEntry.getWhereClause(nestedPath, criterion, operator);
        }
        throw new IllegalArgumentException("unexpected mapping");
    }
}

