/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.query.SortOrder;
import org.eclipse.edc.sql.translation.CriterionToWhereClauseConverter;
import org.eclipse.edc.sql.translation.CriterionToWhereClauseConverterImpl;
import org.eclipse.edc.sql.translation.SortFieldConverter;
import org.eclipse.edc.sql.translation.SortFieldConverterImpl;
import org.eclipse.edc.sql.translation.SqlOperatorTranslator;
import org.eclipse.edc.sql.translation.TranslationMapping;

public class SqlQueryStatement {
    private static final String LIMIT = "LIMIT ? ";
    private static final String OFFSET = "OFFSET ?";
    private static final String ORDER_BY_TOKEN = "ORDER BY %s %s";
    private final String selectStatement;
    private final List<String> whereClauses = new ArrayList<String>();
    private final List<Object> parameters = new ArrayList<Object>();
    private final int limit;
    private final int offset;
    private CriterionToWhereClauseConverter criterionToWhereConditionConverter;
    private SortFieldConverter sortFieldConverter;
    private String orderByClause = "";

    public SqlQueryStatement(String selectStatement, QuerySpec query, TranslationMapping rootModel, SqlOperatorTranslator operatorTranslator) {
        this(selectStatement, query, rootModel, new CriterionToWhereClauseConverterImpl(rootModel, operatorTranslator));
    }

    public SqlQueryStatement(String selectStatement, QuerySpec query, TranslationMapping rootModel, CriterionToWhereClauseConverter criterionToWhereClauseConverter) {
        this(selectStatement, query.getLimit(), query.getOffset());
        this.criterionToWhereConditionConverter = criterionToWhereClauseConverter;
        this.sortFieldConverter = new SortFieldConverterImpl(rootModel);
        this.initialize(query);
    }

    public SqlQueryStatement(String selectStatement, int limit, int offset) {
        this.selectStatement = selectStatement;
        this.limit = limit;
        this.offset = offset;
    }

    public String getQueryAsString() {
        String whereClause = this.whereClauses.isEmpty() ? "" : this.whereClauses.stream().collect(Collectors.joining(" AND ", "WHERE ", " "));
        return this.selectStatement + " " + whereClause + this.orderByClause + "LIMIT ? OFFSET ?;";
    }

    public Object[] getParameters() {
        ArrayList<Object> params = new ArrayList<Object>(this.parameters);
        params.add(this.limit);
        params.add(this.offset);
        return params.toArray(Object[]::new);
    }

    public SqlQueryStatement addWhereClause(String clause, Object ... parameters) {
        this.whereClauses.add(clause);
        Collections.addAll(this.parameters, parameters);
        return this;
    }

    private void initialize(QuerySpec query) {
        query.getFilterExpression().stream().map(criterion -> this.criterionToWhereConditionConverter.convert((Criterion)criterion)).forEach(whereClause -> {
            this.whereClauses.add(whereClause.sql());
            this.parameters.addAll(whereClause.parameters());
        });
        this.orderByClause = this.parseSortField(query);
    }

    private String parseSortField(QuerySpec query) {
        if (query.getSortField() == null) {
            return this.orderByClause;
        }
        String order = query.getSortOrder() == SortOrder.ASC ? "ASC" : "DESC";
        String sortField = this.sortFieldConverter.convert(query.getSortField());
        if (sortField == null) {
            throw new IllegalArgumentException(String.format("Cannot sort by %s because the field does not exist", query.getSortField()));
        }
        return String.format("ORDER BY %s %s ", sortField, order);
    }
}

