/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.translation.FieldTranslator;
import org.eclipse.edc.sql.translation.SqlOperator;
import org.eclipse.edc.sql.translation.WhereClause;
import org.eclipse.edc.util.reflection.PathItem;

public class JsonFieldTranslator
implements FieldTranslator {
    protected final String columnName;

    public JsonFieldTranslator(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public String getLeftOperand(List<PathItem> path, Class<?> type) {
        StringBuilder statementBuilder = new StringBuilder(this.columnName);
        int length = path.size();
        IntStream.range(0, length - 1).mapToObj(i -> " -> '%s'".formatted(path.get(i))).forEach(statementBuilder::append);
        statementBuilder.append(" ->> '%s'".formatted(path.get(length - 1)));
        String statement = statementBuilder.toString();
        return this.createStatementForType(type, statement);
    }

    @Override
    public WhereClause toWhereClause(List<PathItem> path, Criterion criterion, SqlOperator operator) {
        String leftOperand = this.getLeftOperand(path, criterion.getOperandRight().getClass());
        String amendedLeftOperand = Optional.of(leftOperand).filter(it -> operator.representation().equals("??")).map(it -> it.replace("->>", "->")).map(arg_0 -> JsonFieldTranslator.lambda$toWhereClause$3("(%s)::jsonb", arg_0)).orElse(leftOperand);
        return new WhereClause("%s %s %s".formatted(amendedLeftOperand, operator.representation(), FieldTranslator.toValuePlaceholder(criterion)), this.toParameters(criterion));
    }

    private String createStatementForType(Class<?> type, String statement) {
        if (type.equals(Boolean.class)) {
            return String.format("(%s)::boolean", statement);
        }
        if (type.equals(Integer.class)) {
            return String.format("(%s)::integer", statement);
        }
        if (type.equals(Double.class)) {
            return String.format("(%s)::double", statement);
        }
        if (type.equals(Float.class)) {
            return String.format("(%s)::float", statement);
        }
        if (type.equals(Long.class)) {
            return String.format("(%s)::long", statement);
        }
        if (type.equals(Short.class)) {
            return String.format("(%s)::short", statement);
        }
        return statement;
    }

    private static /* synthetic */ String lambda$toWhereClause$3(String rec$, Object xva$0) {
        return "(%s)::jsonb".formatted(xva$0);
    }
}

