/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import java.util.Collection;
import java.util.List;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.translation.FieldTranslator;
import org.eclipse.edc.sql.translation.SqlOperator;
import org.eclipse.edc.sql.translation.WhereClause;
import org.eclipse.edc.util.reflection.PathItem;

public class JsonArrayTranslator
implements FieldTranslator {
    protected final String columnName;

    public JsonArrayTranslator(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public String getLeftOperand(List<PathItem> path, Class<?> rightOperandType) {
        if (Collection.class.isAssignableFrom(rightOperandType)) {
            throw new IllegalArgumentException("JsonArrayTranslator only supports scalar right-operands, found '%s' ".formatted(rightOperandType));
        }
        if (path.size() == 1) {
            return this.columnName;
        }
        throw new IllegalArgumentException("Invalid path for JsonArrayTranslator: must have one element, but found '%s'".formatted(path.size()));
    }

    @Override
    public WhereClause toWhereClause(List<PathItem> path, Criterion criterion, SqlOperator operator) {
        String leftOperand = this.getLeftOperand(path, criterion.getOperandRight().getClass());
        if (!operator.representation().equals("??")) {
            throw new IllegalArgumentException("Invalid operator for JsonArrayTranslator: must be '??', but was '%s'".formatted(operator.representation()));
        }
        return new WhereClause("%s::jsonb ?? %s".formatted(leftOperand, FieldTranslator.toValuePlaceholder(criterion)), this.toParameters(criterion));
    }
}

