/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.translation.SqlOperator;
import org.eclipse.edc.sql.translation.WhereClause;
import org.eclipse.edc.util.reflection.PathItem;

public interface FieldTranslator {
    public static final String PREPARED_STATEMENT_PLACEHOLDER = "?";

    public String getLeftOperand(List<PathItem> var1, Class<?> var2);

    public WhereClause toWhereClause(List<PathItem> var1, Criterion var2, SqlOperator var3);

    default public Collection<Object> toParameters(Criterion criterion) {
        Object operandRight = criterion.getOperandRight();
        if (operandRight == null) {
            return Collections.emptyList();
        }
        if (operandRight instanceof Collection) {
            Collection collection = (Collection)operandRight;
            return Collections.unmodifiableCollection(collection);
        }
        return List.of(operandRight);
    }

    public static String toValuePlaceholder(Criterion criterion) {
        Object object = criterion.getOperandRight();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return String.format("(%s)", String.join((CharSequence)",", Collections.nCopies(collection.size(), PREPARED_STATEMENT_PLACEHOLDER)));
        }
        return PREPARED_STATEMENT_PLACEHOLDER;
    }
}

