/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.translation;

import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.translation.CriterionToWhereClauseConverter;
import org.eclipse.edc.sql.translation.SqlOperator;
import org.eclipse.edc.sql.translation.SqlOperatorTranslator;
import org.eclipse.edc.sql.translation.TranslationMapping;
import org.eclipse.edc.sql.translation.WhereClause;

public class CriterionToWhereClauseConverterImpl
implements CriterionToWhereClauseConverter {
    private final TranslationMapping translationMapping;
    private final SqlOperatorTranslator operatorTranslator;

    public CriterionToWhereClauseConverterImpl(TranslationMapping translationMapping, SqlOperatorTranslator operatorTranslator) {
        this.translationMapping = translationMapping;
        this.operatorTranslator = operatorTranslator;
    }

    @Override
    public WhereClause convert(Criterion criterion) {
        SqlOperator operator = this.operatorTranslator.translate(criterion.getOperator().toLowerCase());
        if (operator == null) {
            throw new IllegalArgumentException("The operator '%s' is not supported".formatted(criterion.getOperator()));
        }
        if (!operator.rightOperandClass().isAssignableFrom(criterion.getOperandRight().getClass())) {
            throw new IllegalArgumentException("The operator '%s' requires the right-hand operand to be of type %s".formatted(criterion.getOperator(), operator.rightOperandClass().getSimpleName()));
        }
        WhereClause whereClause = this.translationMapping.getWhereClause(criterion, operator);
        if (whereClause == null) {
            return new WhereClause("0 = ?", 1);
        }
        return whereClause;
    }
}

