/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.statement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.sql.statement.ColumnEntry;

public class SqlExecuteStatement {
    private final List<ColumnEntry> columnEntries = new ArrayList<ColumnEntry>();
    private final String jsonCastOperator;

    public SqlExecuteStatement(String jsonCastOperator) {
        this.jsonCastOperator = jsonCastOperator;
    }

    public static SqlExecuteStatement newInstance(String jsonCastOperator) {
        return new SqlExecuteStatement(jsonCastOperator);
    }

    public static Criterion equalTo(String columnName) {
        return Criterion.criterion((Object)columnName, (String)"=", (Object)"?");
    }

    public static Criterion isNull(String columnName) {
        return Criterion.criterion((Object)columnName, (String)"is", (Object)"null");
    }

    public SqlExecuteStatement column(String columnName) {
        this.columnEntries.add(ColumnEntry.standardColumn(columnName));
        return this;
    }

    public SqlExecuteStatement jsonColumn(String columnName) {
        this.columnEntries.add(ColumnEntry.jsonColumn(columnName, this.jsonCastOperator));
        return this;
    }

    public String insertInto(String tableName) {
        if (this.columnEntries.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot create INSERT statement on %s because no columns are registered", tableName));
        }
        ColumnEntry columnValues = (ColumnEntry)this.columnEntries.stream().reduce(ColumnEntry::append).orElseThrow();
        return String.format("INSERT INTO %s (%s) VALUES (%s);", tableName, columnValues.columnName(), columnValues.value());
    }

    public String update(String tableName, String whereColumn) {
        return this.update(tableName, Criterion.criterion((Object)whereColumn, (String)"=", (Object)"?"));
    }

    public String update(String tableName, Criterion where) {
        if (this.columnEntries.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot create UPDATE statement on %s because no columns are registered", tableName));
        }
        String statement = this.columnEntries.stream().map(ColumnEntry::asString).collect(Collectors.joining(", "));
        return String.format("UPDATE %s SET %s WHERE %s;", tableName, statement, where);
    }

    public String delete(String tableName, String whereColumn) {
        return this.delete(tableName, Criterion.criterion((Object)whereColumn, (String)"=", (Object)"?"));
    }

    public String delete(String tableName, Criterion ... whereCriteria) {
        String where = Arrays.stream(whereCriteria).map(Criterion::toString).collect(Collectors.joining(" AND "));
        return String.format("DELETE FROM %s WHERE %s;", tableName, where);
    }
}

