/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql.statement;

public record ColumnEntry(String columnName, String value) {
    public static ColumnEntry standardColumn(String columnName) {
        return new ColumnEntry(columnName, "?");
    }

    public static ColumnEntry jsonColumn(String columnName, String jsonOperator) {
        return new ColumnEntry(columnName, "?" + jsonOperator);
    }

    public ColumnEntry append(ColumnEntry other) {
        return new ColumnEntry(this.columnName + ", " + other.columnName, this.value + ", " + other.value);
    }

    public String asString() {
        return String.format("%s = %s", this.columnName, this.value);
    }
}

