/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.sql.ArgumentHandlers;
import org.eclipse.edc.sql.DoorKeeper;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.ResultSetMapper;
import org.eclipse.edc.sql.SqlQueryExecutorConfiguration;
import org.jetbrains.annotations.NotNull;

public class SqlQueryExecutor
implements QueryExecutor {
    private final SqlQueryExecutorConfiguration configuration;

    public SqlQueryExecutor() {
        this(SqlQueryExecutorConfiguration.ofDefaults());
    }

    public SqlQueryExecutor(SqlQueryExecutorConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public int execute(Connection connection, String sql, Object ... arguments) {
        int n;
        block8: {
            Objects.requireNonNull(connection, "connection");
            Objects.requireNonNull(sql, "sql");
            Objects.requireNonNull(arguments, "arguments");
            PreparedStatement statement = connection.prepareStatement(sql, 1);
            try {
                this.setArguments(statement, arguments);
                int n2 = n = statement.execute() ? 0 : statement.getUpdateCount();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new EdcPersistenceException(exception.getMessage(), (Throwable)exception);
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public <T> T single(Connection connection, boolean closeConnection, ResultSetMapper<T> resultSetMapper, String sql, Object ... arguments) {
        try (Stream<T> stream = this.query(connection, closeConnection, resultSetMapper, sql, arguments);){
            T t = stream.findFirst().orElse(null);
            return t;
        }
    }

    @Override
    public <T> Stream<T> query(Connection connection, boolean closeConnection, ResultSetMapper<T> resultSetMapper, String sql, Object ... arguments) {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(resultSetMapper, "resultSetMapper");
        Objects.requireNonNull(sql, "sql");
        Objects.requireNonNull(arguments, "arguments");
        DoorKeeper doorKeeper = new DoorKeeper();
        try {
            if (closeConnection) {
                doorKeeper.takeCareOf(connection);
            }
            PreparedStatement statement = connection.prepareStatement(sql);
            doorKeeper.takeCareOf(statement);
            statement.setFetchSize(this.configuration.fetchSize());
            this.setArguments(statement, arguments);
            ResultSet resultSet = statement.executeQuery();
            doorKeeper.takeCareOf(resultSet);
            Spliterators.AbstractSpliterator<T> splititerator = this.createSpliterator(resultSetMapper, resultSet);
            return (Stream)StreamSupport.stream(splititerator, false).onClose(doorKeeper::close);
        }
        catch (SQLException sqlEx) {
            try {
                doorKeeper.close();
            }
            catch (Exception ex) {
                sqlEx.addSuppressed(ex);
            }
            throw new EdcPersistenceException((Throwable)sqlEx);
        }
    }

    private void setArguments(PreparedStatement statement, Object[] arguments) throws SQLException {
        for (int index = 0; index < arguments.length; ++index) {
            int position = index + 1;
            this.setArgument(statement, position, arguments[index]);
        }
    }

    private void setArgument(PreparedStatement statement, int position, Object argument) throws SQLException {
        ArgumentHandlers argumentHandler = Arrays.stream(ArgumentHandlers.values()).filter(it -> it.accepts(argument)).findFirst().orElse(null);
        if (argumentHandler != null) {
            argumentHandler.handle(statement, position, argument);
        } else {
            statement.setObject(position, argument);
        }
    }

    @NotNull
    private <T> Spliterators.AbstractSpliterator<T> createSpliterator(final ResultSetMapper<T> resultSetMapper, final ResultSet resultSet) {
        return new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                try {
                    if (!resultSet.next()) {
                        return false;
                    }
                    action.accept(resultSetMapper.mapResultSet(resultSet));
                    return true;
                }
                catch (Exception ex) {
                    throw new EdcPersistenceException((Throwable)ex);
                }
            }
        };
    }
}

