/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.sql;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.edc.sql.ArgumentHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ArgumentHandlers implements ArgumentHandler
{
    INT{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Integer;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setInt(position, (Integer)argument);
        }
    }
    ,
    LONG{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Long;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setLong(position, (Long)argument);
        }
    }
    ,
    DOUBLE{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Double;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setDouble(position, (Double)argument);
        }
    }
    ,
    FLOAT{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Float;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setFloat(position, ((Float)argument).floatValue());
        }
    }
    ,
    SHORT{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Short;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setShort(position, (Short)argument);
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public boolean accepts(Object value) {
            return value instanceof BigDecimal;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setBigDecimal(position, (BigDecimal)argument);
        }
    }
    ,
    STRING{

        @Override
        public boolean accepts(Object value) {
            return value instanceof String;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setString(position, (String)argument);
        }
    }
    ,
    BOOLEAN{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Boolean;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setBoolean(position, (Boolean)argument);
        }
    }
    ,
    DATE{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Date;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setTimestamp(position, new Timestamp(((Date)argument).getTime()));
        }
    }
    ,
    BYTE{

        @Override
        public boolean accepts(Object value) {
            return value instanceof Byte;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setByte(position, (Byte)argument);
        }
    }
    ,
    BYTES{

        @Override
        public boolean accepts(Object value) {
            return value instanceof byte[];
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setBytes(position, (byte[])argument);
        }
    }
    ,
    INPUT_STREAM{

        @Override
        public boolean accepts(Object value) {
            return value instanceof InputStream;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setBlob(position, (InputStream)argument);
        }
    }
    ,
    NULL{

        @Override
        public boolean accepts(Object value) {
            return value == null;
        }

        @Override
        public void handle(PreparedStatement statement, int position, Object argument) throws SQLException {
            statement.setNull(position, 0);
        }
    };

}

