/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.protocolversion.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public class ProtocolVersionRequestMessage
implements RemoteMessage {
    private final Policy policy = Policy.Builder.newInstance().build();
    private String protocol = "unknown";
    private String counterPartyAddress;
    private String counterPartyId;

    private ProtocolVersionRequestMessage() {
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getCounterPartyAddress() {
        return this.counterPartyAddress;
    }

    public String getCounterPartyId() {
        return this.counterPartyId;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public static class Builder {
        private final ProtocolVersionRequestMessage message = new ProtocolVersionRequestMessage();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder protocol(String protocol) {
            this.message.protocol = protocol;
            return this;
        }

        public Builder counterPartyAddress(String callbackAddress) {
            this.message.counterPartyAddress = callbackAddress;
            return this;
        }

        public Builder counterPartyId(String counterPartyId) {
            this.message.counterPartyId = counterPartyId;
            return this;
        }

        public ProtocolVersionRequestMessage build() {
            Objects.requireNonNull(this.message.protocol, "protocol");
            return this.message;
        }
    }
}

