/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.policy.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.edc.policy.evaluator.ConstraintProblem;
import org.eclipse.edc.policy.evaluator.PolicyEvaluationResult;
import org.eclipse.edc.policy.evaluator.RuleProblem;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.AtomicConstraintFunction;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.DynamicAtomicConstraintFunction;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.Prohibition;
import org.eclipse.edc.policy.model.Rule;
import org.eclipse.edc.policy.model.RuleFunction;
import org.eclipse.edc.policy.model.XoneConstraint;

public class PolicyEvaluator
implements Policy.Visitor<Boolean>,
Rule.Visitor<Boolean>,
Constraint.Visitor<Boolean>,
Expression.Visitor<Object> {
    private final List<RuleProblem> ruleProblems = new ArrayList<RuleProblem>();
    private final Map<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>> permissionFunctions = new HashMap<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>>();
    private final List<DynamicConstraintFunctionEntry<? extends Rule>> dynamicPermissionFunctions = new ArrayList<DynamicConstraintFunctionEntry<? extends Rule>>();
    private final Map<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>> dutyFunctions = new HashMap<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>>();
    private final List<DynamicConstraintFunctionEntry<? extends Rule>> dynamicDutyFunctions = new ArrayList<DynamicConstraintFunctionEntry<? extends Rule>>();
    private final Map<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>> prohibitionFunctions = new HashMap<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>>();
    private final List<DynamicConstraintFunctionEntry<? extends Rule>> dynamicProhibitionFunctions = new ArrayList<DynamicConstraintFunctionEntry<? extends Rule>>();
    private final List<RuleFunction<Permission>> permissionRuleFunctions = new ArrayList<RuleFunction<Permission>>();
    private final List<RuleFunction<Duty>> dutyRuleFunctions = new ArrayList<RuleFunction<Duty>>();
    private final List<RuleFunction<Prohibition>> prohibitionRuleFunctions = new ArrayList<RuleFunction<Prohibition>>();
    private Rule ruleContext;

    private PolicyEvaluator() {
    }

    public PolicyEvaluationResult evaluate(Policy policy) {
        return (Boolean)policy.accept((Policy.Visitor)this) != false ? new PolicyEvaluationResult() : new PolicyEvaluationResult(this.ruleProblems);
    }

    public Boolean visitPolicy(Policy policy) {
        policy.getPermissions().forEach(permission -> permission.accept((Rule.Visitor)this));
        policy.getProhibitions().forEach(prohibition -> prohibition.accept((Rule.Visitor)this));
        policy.getObligations().forEach(duty -> duty.accept((Rule.Visitor)this));
        return this.ruleProblems.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean visitPermission(Permission permission) {
        for (RuleFunction<Permission> function : this.permissionRuleFunctions) {
            if (function.evaluate((Rule)permission)) continue;
            this.ruleProblems.add(RuleProblem.Builder.newInstance().rule((Rule)permission).description("Evalution failed for: " + permission.toString()).build());
            return false;
        }
        try {
            if (permission.getDuties() != null) {
                for (Duty duty : permission.getDuties()) {
                    this.ruleContext = duty;
                    if (this.visitRule((Rule)duty).booleanValue()) continue;
                    Boolean bl = false;
                    return bl;
                }
            }
            this.ruleContext = permission;
            Boolean bl = this.visitRule((Rule)permission);
            return bl;
        }
        finally {
            this.ruleContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean visitProhibition(Prohibition prohibition) {
        for (RuleFunction<Prohibition> function : this.prohibitionRuleFunctions) {
            if (!function.evaluate((Rule)prohibition)) continue;
            this.ruleProblems.add(RuleProblem.Builder.newInstance().rule((Rule)prohibition).description("Evalution failed for: " + prohibition.toString()).build());
            return false;
        }
        try {
            this.ruleContext = prohibition;
            Boolean bl = this.visitRule((Rule)prohibition);
            return bl;
        }
        finally {
            this.ruleContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean visitDuty(Duty duty) {
        for (RuleFunction<Duty> function : this.dutyRuleFunctions) {
            if (function.evaluate((Rule)duty)) continue;
            this.ruleProblems.add(RuleProblem.Builder.newInstance().rule((Rule)duty).description("Evalution failed for: " + duty.toString()).build());
            return false;
        }
        try {
            this.ruleContext = duty;
            Boolean bl = this.visitRule((Rule)duty);
            return bl;
        }
        finally {
            this.ruleContext = null;
        }
    }

    public Boolean visitAndConstraint(AndConstraint andConstraint) {
        return andConstraint.getConstraints().stream().allMatch(constraint -> (Boolean)constraint.accept((Constraint.Visitor)this));
    }

    public Boolean visitOrConstraint(OrConstraint orConstraint) {
        return orConstraint.getConstraints().stream().anyMatch(constraint -> (Boolean)constraint.accept((Constraint.Visitor)this));
    }

    public Boolean visitXoneConstraint(XoneConstraint xoneConstraint) {
        int count = 0;
        for (Constraint constraint : xoneConstraint.getConstraints()) {
            if (!((Boolean)constraint.accept((Constraint.Visitor)this)).booleanValue() || ++count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    public Boolean visitAtomicConstraint(AtomicConstraint constraint) {
        AtomicConstraintFunction<Object, Rule, Boolean> function;
        Object rightValue = constraint.getRightExpression().accept((Expression.Visitor)this);
        Object leftRawValue = constraint.getLeftExpression().accept((Expression.Visitor)this);
        if (leftRawValue instanceof String && (function = this.ruleContext instanceof Permission ? this.getEvaluationFunction((String)leftRawValue, this.permissionFunctions, this.dynamicPermissionFunctions) : (this.ruleContext instanceof Prohibition ? this.getEvaluationFunction((String)leftRawValue, this.prohibitionFunctions, this.dynamicProhibitionFunctions) : this.getEvaluationFunction((String)leftRawValue, this.dutyFunctions, this.dynamicDutyFunctions))) != null) {
            return (Boolean)function.evaluate(constraint.getOperator(), rightValue, this.ruleContext);
        }
        switch (constraint.getOperator()) {
            case EQ: {
                return Objects.equals(leftRawValue, rightValue);
            }
            case IN: {
                return Objects.equals(leftRawValue, rightValue);
            }
            case NEQ: {
                return !Objects.equals(leftRawValue, rightValue);
            }
            case GT: {
                break;
            }
            case GEQ: {
                break;
            }
            case LT: {
                break;
            }
            case LEQ: {
                break;
            }
        }
        return null;
    }

    public Object visitLiteralExpression(LiteralExpression expression) {
        return expression.getValue();
    }

    private AtomicConstraintFunction<Object, Rule, Boolean> getEvaluationFunction(String leftRawValue, Map<String, AtomicConstraintFunction<Object, ? extends Rule, Boolean>> functions, List<DynamicConstraintFunctionEntry<? extends Rule>> dynamicFunctions) {
        return Optional.ofNullable(functions.get(leftRawValue)).orElseGet(() -> this.getDynamicFunction(leftRawValue, dynamicFunctions));
    }

    private AtomicConstraintFunction<Object, Rule, Boolean> getDynamicFunction(String leftRawValue, List<DynamicConstraintFunctionEntry<? extends Rule>> dynamicFunctions) {
        return dynamicFunctions.stream().filter(entry -> entry.guard.apply(leftRawValue)).map(entry -> entry.function).map(dynamicFunction -> this.wrapDynamicFunction(leftRawValue, (DynamicAtomicConstraintFunction<Object, Object, Rule, Boolean>)dynamicFunction)).findFirst().orElse(null);
    }

    private AtomicConstraintFunction<Object, Rule, Boolean> wrapDynamicFunction(String leftRawValue, DynamicAtomicConstraintFunction<Object, Object, Rule, Boolean> dynamicFunction) {
        return (operator, rightValue, rule) -> (Boolean)dynamicFunction.evaluate((Object)leftRawValue, operator, rightValue, rule);
    }

    private Boolean visitRule(Rule rule) {
        boolean valid = true;
        RuleProblem.Builder problemBuilder = null;
        for (Constraint constraint : rule.getConstraints()) {
            Boolean result = (Boolean)constraint.accept((Constraint.Visitor)this);
            if ((result.booleanValue() || this.ruleContext instanceof Prohibition) && (!result.booleanValue() || !(this.ruleContext instanceof Prohibition))) continue;
            if (problemBuilder == null) {
                problemBuilder = RuleProblem.Builder.newInstance().rule(rule).description(rule.toString());
            }
            String message = this.ruleContext instanceof Prohibition ? "Prohibited constraint evaluated true" : "Constraint evaluated false";
            problemBuilder.constraintProblem(new ConstraintProblem(message + " => " + constraint, constraint));
            valid = false;
        }
        if (!valid) {
            this.ruleProblems.add(problemBuilder.build());
        }
        return valid;
    }

    record DynamicConstraintFunctionEntry<R extends Rule>(Function<Object, Boolean> guard, DynamicAtomicConstraintFunction<Object, Object, R, Boolean> function) {
    }

    public static class Builder {
        private final PolicyEvaluator evaluator = new PolicyEvaluator();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder permissionFunction(String key, AtomicConstraintFunction<Object, Permission, Boolean> function) {
            this.evaluator.permissionFunctions.put(key, function);
            return this;
        }

        public Builder dynamicPermissionFunction(Function<Object, Boolean> guard, DynamicAtomicConstraintFunction<Object, Object, Permission, Boolean> function) {
            this.evaluator.dynamicPermissionFunctions.add(new DynamicConstraintFunctionEntry<Permission>(guard, function));
            return this;
        }

        public Builder dutyFunction(String key, AtomicConstraintFunction<Object, Duty, Boolean> function) {
            this.evaluator.dutyFunctions.put(key, function);
            return this;
        }

        public Builder dynamicDutyFunction(Function<Object, Boolean> guard, DynamicAtomicConstraintFunction<Object, Object, Duty, Boolean> function) {
            this.evaluator.dynamicDutyFunctions.add(new DynamicConstraintFunctionEntry<Duty>(guard, function));
            return this;
        }

        public Builder prohibitionFunction(String key, AtomicConstraintFunction<Object, Prohibition, Boolean> function) {
            this.evaluator.prohibitionFunctions.put(key, function);
            return this;
        }

        public Builder dynamicProhibitionFunction(Function<Object, Boolean> guard, DynamicAtomicConstraintFunction<Object, Object, Prohibition, Boolean> function) {
            this.evaluator.dynamicProhibitionFunctions.add(new DynamicConstraintFunctionEntry<Prohibition>(guard, function));
            return this;
        }

        public Builder permissionRuleFunction(RuleFunction<Permission> function) {
            this.evaluator.permissionRuleFunctions.add(function);
            return this;
        }

        public Builder dutyRuleFunction(RuleFunction<Duty> function) {
            this.evaluator.dutyRuleFunctions.add(function);
            return this;
        }

        public Builder prohibitionRuleFunction(RuleFunction<Prohibition> function) {
            this.evaluator.prohibitionRuleFunctions.add(function);
            return this;
        }

        public PolicyEvaluator build() {
            return this.evaluator;
        }
    }
}

