/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.policy.evaluator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.policy.evaluator.ConstraintProblem;
import org.eclipse.edc.policy.model.Rule;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(builder=Builder.class)
public class RuleProblem {
    private Rule rule;
    private String description;
    private final List<ConstraintProblem> constraintProblems = new ArrayList<ConstraintProblem>();

    private RuleProblem() {
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<ConstraintProblem> getConstraintProblem() {
        return this.constraintProblems;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final RuleProblem ruleProblem = new RuleProblem();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder rule(Rule rule) {
            this.ruleProblem.rule = rule;
            return this;
        }

        public Builder description(String description) {
            this.ruleProblem.description = description;
            return this;
        }

        public Builder constraintProblems(List<ConstraintProblem> problems) {
            this.ruleProblem.constraintProblems.addAll(problems);
            return this;
        }

        public Builder constraintProblem(ConstraintProblem problem) {
            this.ruleProblem.constraintProblems.add(problem);
            return this;
        }

        public RuleProblem build() {
            return this.ruleProblem;
        }
    }
}

