/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.policy.engine.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.jetbrains.annotations.NotNull;

public class PolicyContextImpl
implements PolicyContext {
    private final List<String> problems = new ArrayList<String>();
    private final Map<Class<?>, Object> additional = new HashMap();

    private PolicyContextImpl() {
    }

    @Override
    public void reportProblem(String problem) {
        this.problems.add(problem);
    }

    @Override
    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        return this.problems;
    }

    @Override
    public <T> T getContextData(Class<T> type) {
        return (T)this.additional.get(type);
    }

    @Override
    public <T> void putContextData(Class<T> type, T data) {
        this.additional.put(type, data);
    }

    public static class Builder {
        private final PolicyContextImpl context = new PolicyContextImpl();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder additional(Class<?> clazz, Object object) {
            this.context.additional.put(clazz, object);
            return this;
        }

        public PolicyContext build() {
            return this.context;
        }
    }
}

