/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.policy.engine.spi.plan.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.edc.policy.engine.spi.plan.step.ConstraintStep;
import org.eclipse.edc.policy.engine.spi.plan.step.RuleFunctionStep;
import org.eclipse.edc.policy.model.Rule;

public abstract class RuleStep<R extends Rule> {
    public static final String EDC_RULE_STEP_IS_FILTERED = "https://w3id.org/edc/v0.0.1/ns/isFiltered";
    public static final String EDC_RULE_STEP_FILTERING_REASONS = "https://w3id.org/edc/v0.0.1/ns/filteringReasons";
    public static final String EDC_RULE_CONSTRAINT_STEPS = "https://w3id.org/edc/v0.0.1/ns/constraintSteps";
    public static final String EDC_RULE_FUNCTIONS = "https://w3id.org/edc/v0.0.1/ns/ruleFunctions";
    protected R rule;
    protected boolean isFiltered = false;
    protected List<ConstraintStep> constraintSteps = new ArrayList<ConstraintStep>();
    protected List<String> filteringReasons = new ArrayList<String>();
    protected List<RuleFunctionStep<R>> ruleFunctions = new ArrayList<RuleFunctionStep<R>>();

    public List<ConstraintStep> getConstraintSteps() {
        return this.constraintSteps;
    }

    public List<RuleFunctionStep<R>> getRuleFunctions() {
        return this.ruleFunctions;
    }

    public List<String> getFilteringReasons() {
        return this.filteringReasons;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public static abstract class Builder<R extends Rule, T extends RuleStep<R>, B extends Builder<R, T, B>> {
        protected T ruleStep;

        public B rule(R rule) {
            ((RuleStep)this.ruleStep).rule = rule;
            return (B)this;
        }

        public B constraint(ConstraintStep constraint) {
            ((RuleStep)this.ruleStep).constraintSteps.add(constraint);
            return (B)this;
        }

        public B ruleFunction(RuleFunctionStep<R> function) {
            ((RuleStep)this.ruleStep).ruleFunctions.add(function);
            return (B)this;
        }

        public B filtered(boolean isFiltered) {
            ((RuleStep)this.ruleStep).isFiltered = isFiltered;
            return (B)this;
        }

        public B filteringReason(String reason) {
            ((RuleStep)this.ruleStep).filteringReasons.add(reason);
            return (B)this;
        }

        public T build() {
            Objects.requireNonNull(((RuleStep)this.ruleStep).rule, "Rule should not be null");
            return this.ruleStep;
        }
    }
}

