/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.policy.engine.spi.plan;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.policy.engine.spi.plan.step.DutyStep;
import org.eclipse.edc.policy.engine.spi.plan.step.PermissionStep;
import org.eclipse.edc.policy.engine.spi.plan.step.ProhibitionStep;
import org.eclipse.edc.policy.engine.spi.plan.step.ValidatorStep;

public class PolicyEvaluationPlan {
    public static final String EDC_POLICY_EVALUATION_PLAN_TYPE = "https://w3id.org/edc/v0.0.1/ns/PolicyEvaluationPlan";
    public static final String EDC_POLICY_EVALUATION_PLAN_PRE_VALIDATORS = "https://w3id.org/edc/v0.0.1/ns/preValidators";
    public static final String EDC_POLICY_EVALUATION_PLAN_POST_VALIDATORS = "https://w3id.org/edc/v0.0.1/ns/postValidators";
    public static final String EDC_POLICY_EVALUATION_PLAN_PERMISSION_STEPS = "https://w3id.org/edc/v0.0.1/ns/permissionSteps";
    public static final String EDC_POLICY_EVALUATION_PLAN_PROHIBITION_STEPS = "https://w3id.org/edc/v0.0.1/ns/prohibitionSteps";
    public static final String EDC_POLICY_EVALUATION_PLAN_OBLIGATION_STEPS = "https://w3id.org/edc/v0.0.1/ns/obligationSteps";
    private final List<ValidatorStep> preValidators = new ArrayList<ValidatorStep>();
    private final List<ValidatorStep> postValidators = new ArrayList<ValidatorStep>();
    private final List<PermissionStep> permissionSteps = new ArrayList<PermissionStep>();
    private final List<ProhibitionStep> prohibitionSteps = new ArrayList<ProhibitionStep>();
    private final List<DutyStep> obligationSteps = new ArrayList<DutyStep>();

    public List<ValidatorStep> getPostValidators() {
        return this.postValidators;
    }

    public List<ValidatorStep> getPreValidators() {
        return this.preValidators;
    }

    public List<PermissionStep> getPermissionSteps() {
        return this.permissionSteps;
    }

    public List<DutyStep> getObligationSteps() {
        return this.obligationSteps;
    }

    public List<ProhibitionStep> getProhibitionSteps() {
        return this.prohibitionSteps;
    }

    public static class Builder {
        private final PolicyEvaluationPlan plan = new PolicyEvaluationPlan();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder preValidator(ValidatorStep validatorStep) {
            this.plan.preValidators.add(validatorStep);
            return this;
        }

        public Builder permission(PermissionStep permissionStep) {
            this.plan.permissionSteps.add(permissionStep);
            return this;
        }

        public Builder prohibition(ProhibitionStep prohibitionStep) {
            this.plan.prohibitionSteps.add(prohibitionStep);
            return this;
        }

        public Builder duty(DutyStep dutyStep) {
            this.plan.obligationSteps.add(dutyStep);
            return this;
        }

        public Builder postValidator(ValidatorStep validatorStep) {
            this.plan.postValidators.add(validatorStep);
            return this;
        }

        public PolicyEvaluationPlan build() {
            return this.plan;
        }
    }
}

