/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.store.sql.policydefinition.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.edc.connector.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.connector.store.sql.policydefinition.store.schema.SqlPolicyStoreStatements;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.PolicyType;
import org.eclipse.edc.policy.model.Prohibition;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class SqlPolicyDefinitionStore
extends AbstractSqlStore
implements PolicyDefinitionStore {
    private final SqlPolicyStoreStatements statements;
    private final TypeReference<List<Permission>> permissionListType = new TypeReference<List<Permission>>(){};
    private final TypeReference<List<Prohibition>> prohibitionListType = new TypeReference<List<Prohibition>>(){};
    private final TypeReference<List<Duty>> dutyListType = new TypeReference<List<Duty>>(){};
    private final TypeReference<PolicyType> policyType = new TypeReference<PolicyType>(){};
    private final TypeReference<Map<String, Object>> extensiblePropertiesType = new TypeReference<Map<String, Object>>(){};

    public SqlPolicyDefinitionStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, SqlPolicyStoreStatements sqlPolicyStoreStatements, QueryExecutor queryExecutor) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = Objects.requireNonNull(sqlPolicyStoreStatements);
    }

    public PolicyDefinition findById(String id) {
        return (PolicyDefinition)this.transactionContext.execute(() -> {
            QuerySpec query = QuerySpec.Builder.newInstance().filter(List.of(new Criterion((Object)"id", "=", (Object)id))).build();
            try {
                SqlQueryStatement queryStatement = this.statements.createQuery(query);
                return (PolicyDefinition)this.queryExecutor.single(this.getConnection(), true, this::mapResultSet, queryStatement.getQueryAsString(), queryStatement.getParameters());
            }
            catch (SQLException exception) {
                throw new EdcPersistenceException((Throwable)exception);
            }
        });
    }

    public Stream<PolicyDefinition> findAll(QuerySpec querySpec) {
        Objects.requireNonNull(querySpec);
        return (Stream)this.transactionContext.execute(() -> {
            try {
                SqlQueryStatement queryStatement = this.statements.createQuery(querySpec);
                return this.queryExecutor.query(this.getConnection(), true, this::mapResultSet, queryStatement.getQueryAsString(), queryStatement.getParameters());
            }
            catch (SQLException exception) {
                throw new EdcPersistenceException((Throwable)exception);
            }
        });
    }

    public StoreResult<PolicyDefinition> create(PolicyDefinition policy) {
        Objects.requireNonNull(policy);
        String policyId = policy.getUid();
        return (StoreResult)this.transactionContext.execute(() -> {
            if (this.findById(policy.getUid()) != null) {
                return StoreResult.alreadyExists((String)String.format("Policy with ID %s already exists", policyId));
            }
            this.insert(policy);
            return StoreResult.success((Object)policy);
        });
    }

    public StoreResult<PolicyDefinition> update(PolicyDefinition policyDefinition) {
        String policyId = policyDefinition.getUid();
        if (this.findById(policyId) != null) {
            return (StoreResult)this.transactionContext.execute(() -> {
                this.updateInternal(policyDefinition);
                return StoreResult.success((Object)policyDefinition);
            });
        }
        return StoreResult.notFound((String)String.format("Policy with ID %s could not be found", policyId));
    }

    public StoreResult<PolicyDefinition> delete(String policyId) {
        Objects.requireNonNull(policyId);
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                PolicyDefinition entity = this.findById(policyId);
                if (entity != null) {
                    this.queryExecutor.execute(connection, this.statements.getDeleteTemplate(), new Object[]{policyId});
                    StoreResult storeResult2 = StoreResult.success((Object)entity);
                    return storeResult2;
                }
                StoreResult storeResult = StoreResult.notFound((String)String.format("Policy with ID %s could not be found", policyId));
                return storeResult;
            }
            catch (Exception e) {
                throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
            }
        });
    }

    private void insert(PolicyDefinition def) {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                Policy policy = def.getPolicy();
                String id = def.getUid();
                this.queryExecutor.execute(connection, this.statements.getInsertTemplate(), new Object[]{id, this.toJson(policy.getPermissions(), this.permissionListType), this.toJson(policy.getProhibitions(), this.prohibitionListType), this.toJson(policy.getObligations(), this.dutyListType), this.toJson(policy.getExtensibleProperties()), policy.getInheritsFrom(), policy.getAssigner(), policy.getAssignee(), policy.getTarget(), this.toJson(policy.getType(), this.policyType), def.getCreatedAt()});
            }
            catch (Exception e) {
                throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
            }
        });
    }

    private void updateInternal(PolicyDefinition def) {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                Policy policy = def.getPolicy();
                String id = def.getUid();
                this.queryExecutor.execute(connection, this.statements.getUpdateTemplate(), new Object[]{this.toJson(policy.getPermissions(), this.permissionListType), this.toJson(policy.getProhibitions(), this.prohibitionListType), this.toJson(policy.getObligations(), this.dutyListType), this.toJson(policy.getExtensibleProperties()), policy.getInheritsFrom(), policy.getAssigner(), policy.getAssignee(), policy.getTarget(), this.toJson(policy.getType(), this.policyType), id});
            }
            catch (Exception e) {
                throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
            }
        });
    }

    private PolicyDefinition mapResultSet(ResultSet resultSet) throws SQLException {
        Policy policy = Policy.Builder.newInstance().permissions((List)this.fromJson(resultSet.getString(this.statements.getPermissionsColumn()), this.permissionListType)).prohibitions((List)this.fromJson(resultSet.getString(this.statements.getProhibitionsColumn()), this.prohibitionListType)).duties((List)this.fromJson(resultSet.getString(this.statements.getDutiesColumn()), this.dutyListType)).extensibleProperties((Map)this.fromJson(resultSet.getString(this.statements.getExtensiblePropertiesColumn()), this.extensiblePropertiesType)).inheritsFrom(resultSet.getString(this.statements.getInheritsFromColumn())).assigner(resultSet.getString(this.statements.getAssignerColumn())).assignee(resultSet.getString(this.statements.getAssigneeColumn())).target(resultSet.getString(this.statements.getTargetColumn())).type((PolicyType)this.fromJson(resultSet.getString(this.statements.getTypeColumn()), this.policyType)).build();
        return ((PolicyDefinition.Builder)((PolicyDefinition.Builder)PolicyDefinition.Builder.newInstance().id(resultSet.getString(this.statements.getPolicyIdColumn()))).policy(policy).createdAt(resultSet.getLong(this.statements.getCreatedAtColumn()))).build();
    }
}

