/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.store.sql.policydefinition;

import org.eclipse.edc.connector.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.connector.store.sql.policydefinition.store.SqlPolicyDefinitionStore;
import org.eclipse.edc.connector.store.sql.policydefinition.store.schema.SqlPolicyStoreStatements;
import org.eclipse.edc.connector.store.sql.policydefinition.store.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={PolicyDefinitionStore.class})
@Extension(value="SQL policy store")
public class SqlPolicyStoreExtension
implements ServiceExtension {
    @Setting(required=true)
    public static final String DATASOURCE_SETTING_NAME = "edc.datasource.policy.name";
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject(required=false)
    private SqlPolicyStoreStatements statements;
    @Inject
    private TypeManager typeManager;
    @Inject
    private QueryExecutor queryExecutor;

    public void initialize(ServiceExtensionContext context) {
        SqlPolicyDefinitionStore sqlPolicyStore = new SqlPolicyDefinitionStore(this.dataSourceRegistry, this.getDataSourceName(context), this.transactionContext, this.typeManager.getMapper(), this.getStatementImpl(), this.queryExecutor);
        context.registerService(PolicyDefinitionStore.class, (Object)sqlPolicyStore);
    }

    private SqlPolicyStoreStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }

    private String getDataSourceName(ServiceExtensionContext context) {
        return context.getConfig().getString(DATASOURCE_SETTING_NAME, "default");
    }
}

