/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.spi.participantcontext.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import java.util.UUID;

@JsonDeserialize(builder=Builder.class)
public class KeyDescriptor {
    private String resourceId = UUID.randomUUID().toString();
    private String keyId;
    private String type;
    private String privateKeyAlias;
    private Map<String, Object> publicKeyJwk;
    private String publicKeyPem;
    private Map<String, Object> keyGeneratorParams;
    private boolean isActive = true;

    private KeyDescriptor() {
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getType() {
        return this.type;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public Map<String, Object> getPublicKeyJwk() {
        return this.publicKeyJwk;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public Map<String, Object> getKeyGeneratorParams() {
        return this.keyGeneratorParams;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final KeyDescriptor keyDescriptor = new KeyDescriptor();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder keyId(String keyId) {
            this.keyDescriptor.keyId = keyId;
            return this;
        }

        public Builder type(String type) {
            this.keyDescriptor.type = type;
            return this;
        }

        public Builder privateKeyAlias(String privateKeyAlias) {
            this.keyDescriptor.privateKeyAlias = privateKeyAlias;
            return this;
        }

        public Builder publicKeyJwk(Map<String, Object> publicKeyJwk) {
            this.keyDescriptor.publicKeyJwk = publicKeyJwk;
            return this;
        }

        public Builder publicKeyPem(String publicKeyPem) {
            this.keyDescriptor.publicKeyPem = publicKeyPem;
            return this;
        }

        public Builder keyGeneratorParams(Map<String, Object> keyGeneratorParams) {
            this.keyDescriptor.keyGeneratorParams = keyGeneratorParams;
            return this;
        }

        public Builder active(boolean isActive) {
            this.keyDescriptor.isActive = isActive;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.keyDescriptor.resourceId = resourceId;
            return this;
        }

        public KeyDescriptor build() {
            if (this.keyDescriptor.type == null) {
                this.keyDescriptor.type = "JsonWebKey2020";
            }
            return this.keyDescriptor;
        }
    }
}

