/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.spi.participantcontext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Clock;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.edc.identityhub.spi.participantcontext.model.AbstractParticipantResource;

public abstract class IdentityResource
extends AbstractParticipantResource {
    protected String id;
    protected long timestamp;
    protected String issuerId;
    protected String holderId;
    @JsonIgnore
    protected Clock clock;

    public Clock getClock() {
        return this.clock;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getHolderId() {
        return this.holderId;
    }

    public static abstract class Builder<T extends IdentityResource, B extends Builder<T, B>>
    extends AbstractParticipantResource.Builder<T, B> {
        protected Builder(T entity) {
            super(entity);
        }

        public B id(String id) {
            ((IdentityResource)this.entity).id = id;
            return (B)((Builder)this.self());
        }

        public B timestamp(long timestamp) {
            ((IdentityResource)this.entity).timestamp = timestamp;
            return (B)((Builder)this.self());
        }

        public B issuerId(String issuerId) {
            ((IdentityResource)this.entity).issuerId = issuerId;
            return (B)((Builder)this.self());
        }

        public B clock(Clock clock) {
            ((IdentityResource)this.entity).clock = clock;
            return (B)((Builder)this.self());
        }

        public B holderId(String holderId) {
            ((IdentityResource)this.entity).holderId = holderId;
            return (B)((Builder)this.self());
        }

        @Override
        protected T build() {
            Objects.requireNonNull(((IdentityResource)this.entity).issuerId, "Must have an issuer.");
            Objects.requireNonNull(((IdentityResource)this.entity).holderId, "Must have a holder.");
            ((IdentityResource)this.entity).clock = Objects.requireNonNullElse(((IdentityResource)this.entity).clock, Clock.systemUTC());
            if (((IdentityResource)this.entity).id == null) {
                ((IdentityResource)this.entity).id = UUID.randomUUID().toString();
            }
            if (((IdentityResource)this.entity).timestamp == 0L) {
                ((IdentityResource)this.entity).timestamp = ((IdentityResource)this.entity).clock.millis();
            }
            return (T)((IdentityResource)super.build());
        }
    }
}

