/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.spi.participantcontext.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.iam.did.spi.document.Service;
import org.eclipse.edc.identityhub.spi.participantcontext.model.KeyDescriptor;

@JsonDeserialize(builder=Builder.class)
public class ParticipantManifest {
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private List<String> roles = new ArrayList<String>();
    private Set<Service> serviceEndpoints = new HashSet<Service>();
    private boolean isActive;
    private String participantId;
    private String did;
    private KeyDescriptor key;

    private ParticipantManifest() {
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String clientSecretAlias() {
        return Optional.ofNullable(this.additionalProperties.get("clientSecret")).map(Object::toString).orElseGet(() -> this.participantId + "-sts-client-secret");
    }

    public Set<Service> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public KeyDescriptor getKey() {
        return this.key;
    }

    public String getDid() {
        return this.did;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Object getProperty(String key) {
        return this.additionalProperties.get(key);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final ParticipantManifest manifest = new ParticipantManifest();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder serviceEndpoints(Set<Service> serviceEndpoints) {
            this.manifest.serviceEndpoints = serviceEndpoints;
            return this;
        }

        public Builder serviceEndpoint(Service serviceEndpoint) {
            this.manifest.serviceEndpoints.add(serviceEndpoint);
            return this;
        }

        public Builder active(boolean isActive) {
            this.manifest.isActive = isActive;
            return this;
        }

        public Builder participantId(String participantId) {
            this.manifest.participantId = participantId;
            return this;
        }

        public Builder key(KeyDescriptor key) {
            this.manifest.key = key;
            return this;
        }

        public Builder roles(List<String> roles) {
            this.manifest.roles = roles;
            return this;
        }

        public Builder did(String did) {
            this.manifest.did = did;
            return this;
        }

        public Builder property(String key, Object value) {
            this.manifest.additionalProperties.put(key, value);
            return this;
        }

        public Builder additionalProperties(Map<String, Object> properties) {
            this.manifest.additionalProperties = properties;
            return this;
        }

        public ParticipantManifest build() {
            return this.manifest;
        }
    }
}

