/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.spi.participantcontext.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.identityhub.spi.participantcontext.model.AbstractParticipantResource;
import org.eclipse.edc.identityhub.spi.participantcontext.model.ParticipantContextState;

@JsonDeserialize(builder=Builder.class)
public class ParticipantContext
extends AbstractParticipantResource {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<String> roles = new ArrayList<String>();
    private String did;
    private long createdAt;
    private long lastModified;
    private int state;
    private String apiTokenAlias;

    private ParticipantContext() {
    }

    public String clientSecretAlias() {
        return Optional.ofNullable(this.properties.get("clientSecret")).map(Object::toString).orElseGet(() -> this.participantContextId + "-sts-client-secret");
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getState() {
        return this.state;
    }

    @JsonIgnore
    public ParticipantContextState getStateAsEnum() {
        return ParticipantContextState.values()[this.state];
    }

    public String getApiTokenAlias() {
        return this.apiTokenAlias;
    }

    public void updateLastModified() {
        this.lastModified = Instant.now().toEpochMilli();
    }

    public void activate() {
        this.state = ParticipantContextState.ACTIVATED.ordinal();
    }

    public void deactivate() {
        this.state = ParticipantContextState.DEACTIVATED.ordinal();
    }

    public String getDid() {
        return this.did;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder
    extends AbstractParticipantResource.Builder<ParticipantContext, Builder> {
        private Builder() {
            super(new ParticipantContext());
            ((ParticipantContext)this.entity).createdAt = Instant.now().toEpochMilli();
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder createdAt(long createdAt) {
            ((ParticipantContext)this.entity).createdAt = createdAt;
            return this;
        }

        public Builder lastModified(long lastModified) {
            ((ParticipantContext)this.entity).lastModified = lastModified;
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public Builder participantContextId(String participantContextId) {
            ((ParticipantContext)this.entity).participantContextId = participantContextId;
            return this;
        }

        @Override
        public ParticipantContext build() {
            Objects.requireNonNull(((ParticipantContext)this.entity).participantContextId, "Participant ID cannot be null");
            Objects.requireNonNull(((ParticipantContext)this.entity).apiTokenAlias, "API Token Alias cannot be null");
            if (((ParticipantContext)this.entity).getLastModified() == 0L) {
                ((ParticipantContext)this.entity).lastModified = ((ParticipantContext)this.entity).getCreatedAt();
            }
            return (ParticipantContext)super.build();
        }

        public Builder state(ParticipantContextState state) {
            ((ParticipantContext)this.entity).state = state.ordinal();
            return this;
        }

        public Builder roles(List<String> roles) {
            ((ParticipantContext)this.entity).roles = roles;
            return this;
        }

        public Builder apiTokenAlias(String apiToken) {
            ((ParticipantContext)this.entity).apiTokenAlias = apiToken;
            return this;
        }

        public Builder property(String key, Object value) {
            ((ParticipantContext)this.entity).properties.put(key, value);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            ((ParticipantContext)this.entity).properties = properties;
            return this;
        }

        public Builder did(String did) {
            ((ParticipantContext)this.entity).did = did;
            return this;
        }
    }
}

