/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.spi.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class Oauth2CredentialsRequest {
    private static final String GRANT_TYPE = "grant_type";
    private static final String SCOPE = "scope";
    private static final String RESOURCE = "resource";
    protected String url;
    protected final Map<String, Object> params = new HashMap<String, Object>();

    @NotNull
    public String getUrl() {
        return this.url;
    }

    public String getScope() {
        return Optional.ofNullable(this.params.get(SCOPE)).map(Object::toString).orElse(null);
    }

    public String getGrantType() {
        return Optional.ofNullable(this.params.get(GRANT_TYPE)).map(Object::toString).orElse(null);
    }

    public String getResource() {
        return Optional.ofNullable(this.params.get(RESOURCE)).map(Object::toString).orElse(null);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public static abstract class Builder<T extends Oauth2CredentialsRequest, B extends Builder<T, B>> {
        protected final T request;

        protected Builder(T entity) {
            this.request = entity;
        }

        public B url(String url) {
            ((Oauth2CredentialsRequest)this.request).url = url;
            return this.self();
        }

        public B grantType(String grantType) {
            this.param(Oauth2CredentialsRequest.GRANT_TYPE, grantType);
            return this.self();
        }

        public B scope(String scope) {
            this.param(Oauth2CredentialsRequest.SCOPE, scope);
            return this.self();
        }

        public B param(String key, Object value) {
            ((Oauth2CredentialsRequest)this.request).params.put(key, value);
            return this.self();
        }

        public B params(Map<String, Object> params) {
            ((Oauth2CredentialsRequest)this.request).params.putAll(params);
            return this.self();
        }

        public B resource(String targetedAudience) {
            return this.param(Oauth2CredentialsRequest.RESOURCE, targetedAudience);
        }

        public abstract B self();

        protected T build() {
            Objects.requireNonNull(((Oauth2CredentialsRequest)this.request).url, "url");
            Objects.requireNonNull(((Oauth2CredentialsRequest)this.request).params.get(Oauth2CredentialsRequest.GRANT_TYPE), Oauth2CredentialsRequest.GRANT_TYPE);
            return this.request;
        }
    }
}

