/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.spi.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import org.eclipse.edc.iam.oauth2.spi.client.Oauth2CredentialsRequest;

public class SharedSecretOauth2CredentialsRequest
extends Oauth2CredentialsRequest {
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";

    public Object getClientId() {
        return this.params.get(CLIENT_ID);
    }

    public Object getClientSecret() {
        return this.params.get(CLIENT_SECRET);
    }

    public static class Builder<B extends Builder<B>>
    extends Oauth2CredentialsRequest.Builder<SharedSecretOauth2CredentialsRequest, Builder<B>> {
        protected Builder(SharedSecretOauth2CredentialsRequest request) {
            super(request);
        }

        @JsonCreator
        public static <B extends Builder<B>> Builder<B> newInstance() {
            return new Builder<B>(new SharedSecretOauth2CredentialsRequest());
        }

        public B clientSecret(String secret) {
            this.param(SharedSecretOauth2CredentialsRequest.CLIENT_SECRET, secret);
            return (B)this.self();
        }

        public B clientId(String id) {
            this.param(SharedSecretOauth2CredentialsRequest.CLIENT_ID, id);
            return (B)this.self();
        }

        @Override
        public B self() {
            return (B)this;
        }

        @Override
        public SharedSecretOauth2CredentialsRequest build() {
            Objects.requireNonNull(((SharedSecretOauth2CredentialsRequest)this.request).params.get(SharedSecretOauth2CredentialsRequest.CLIENT_ID), SharedSecretOauth2CredentialsRequest.CLIENT_ID);
            Objects.requireNonNull(((SharedSecretOauth2CredentialsRequest)this.request).params.get(SharedSecretOauth2CredentialsRequest.CLIENT_SECRET), SharedSecretOauth2CredentialsRequest.CLIENT_SECRET);
            return (SharedSecretOauth2CredentialsRequest)super.build();
        }
    }
}

