/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.spi.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.iam.oauth2.spi.client.Oauth2CredentialsRequest;

public class PrivateKeyOauth2CredentialsRequest
extends Oauth2CredentialsRequest {
    private static final String CLIENT_ASSERTION = "client_assertion";
    private static final String CLIENT_ASSERTION_TYPE = "client_assertion_type";
    private static final String TYPE_JWT_BEARER = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";

    public String getClientAssertion() {
        return Optional.ofNullable(this.params.get(CLIENT_ASSERTION)).map(Object::toString).orElse(null);
    }

    public String getClientAssertionType() {
        return Optional.ofNullable(this.params.get(CLIENT_ASSERTION_TYPE)).map(Object::toString).orElse(null);
    }

    public static class Builder<B extends Builder<B>>
    extends Oauth2CredentialsRequest.Builder<PrivateKeyOauth2CredentialsRequest, Builder<B>> {
        protected Builder(PrivateKeyOauth2CredentialsRequest request) {
            super(request);
        }

        @JsonCreator
        public static <B extends Builder<B>> Builder<B> newInstance() {
            return new Builder<B>(new PrivateKeyOauth2CredentialsRequest());
        }

        public B clientAssertion(String assertion) {
            this.param(PrivateKeyOauth2CredentialsRequest.CLIENT_ASSERTION, assertion);
            this.param(PrivateKeyOauth2CredentialsRequest.CLIENT_ASSERTION_TYPE, PrivateKeyOauth2CredentialsRequest.TYPE_JWT_BEARER);
            return (B)this.self();
        }

        @Override
        public B self() {
            return (B)this;
        }

        @Override
        public PrivateKeyOauth2CredentialsRequest build() {
            Objects.requireNonNull(((PrivateKeyOauth2CredentialsRequest)this.request).params.get(PrivateKeyOauth2CredentialsRequest.CLIENT_ASSERTION), PrivateKeyOauth2CredentialsRequest.CLIENT_ASSERTION);
            return (PrivateKeyOauth2CredentialsRequest)super.build();
        }
    }
}

