/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.spi;

import java.util.function.Predicate;
import org.eclipse.edc.spi.types.domain.DataAddress;

public class Oauth2DataAddressValidator
implements Predicate<DataAddress> {
    private final Predicate<DataAddress> hasClientId = dataAddress -> dataAddress.hasProperty("oauth2:clientId");
    private final Predicate<DataAddress> hasClientSecretKey = dataAddress -> dataAddress.hasProperty("oauth2:clientSecretKey");
    private final Predicate<DataAddress> hasPrivateKeySecretName = dataAddress -> dataAddress.hasProperty("oauth2:privateKeyName");
    private final Predicate<DataAddress> hasTokenUrl = dataAddress -> dataAddress.hasProperty("oauth2:tokenUrl");
    private final Predicate<DataAddress> hasSecretInfo = this.hasClientSecretKey.or(this.hasPrivateKeySecretName);

    @Override
    public boolean test(DataAddress dataAddress) {
        return this.hasClientId.and(this.hasTokenUrl).and(this.hasSecretInfo).test(dataAddress);
    }
}

