/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.edc.spi.iam.TokenParameters;
import org.eclipse.edc.token.spi.KeyIdDecorator;
import org.eclipse.edc.token.spi.TokenDecorator;

public class Oauth2AssertionDecorator
implements TokenDecorator {
    private String audience;
    private String clientId;
    private Clock clock;
    private long validity;
    private String kid;

    private Oauth2AssertionDecorator() {
    }

    public TokenParameters.Builder decorate(TokenParameters.Builder tokenParameters) {
        new KeyIdDecorator(this.kid).decorate(tokenParameters);
        return tokenParameters.claims("aud", List.of(this.audience)).claims("iss", (Object)this.clientId).claims("sub", (Object)this.clientId).claims("jti", (Object)UUID.randomUUID().toString()).claims("iat", (Object)this.clock.instant().getEpochSecond()).claims("exp", (Object)this.clock.instant().plusSeconds(this.validity).getEpochSecond());
    }

    public static class Builder {
        private final Oauth2AssertionDecorator decorator = new Oauth2AssertionDecorator();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder audience(String audience) {
            this.decorator.audience = audience;
            return this;
        }

        public Builder clientId(String clientId) {
            this.decorator.clientId = clientId;
            return this;
        }

        public Builder clock(Clock clock) {
            this.decorator.clock = clock;
            return this;
        }

        public Builder validity(long validity) {
            this.decorator.validity = validity;
            return this;
        }

        public Builder kid(String kid) {
            this.decorator.kid = kid;
            return this;
        }

        public Oauth2AssertionDecorator build() {
            Objects.requireNonNull(this.decorator.audience, "Audience must be set");
            Objects.requireNonNull(this.decorator.clientId, "Client ID must be set");
            if (this.decorator.validity <= 0L) {
                throw new IllegalArgumentException("Validity must be greater than 0");
            }
            this.decorator.clock = Objects.requireNonNullElse(this.decorator.clock, Clock.systemUTC());
            return this.decorator;
        }
    }
}

