/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.oauth2.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.iam.oauth2.spi.client.Oauth2Client;
import org.eclipse.edc.iam.oauth2.spi.client.Oauth2CredentialsRequest;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.http.FallbackFactories;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.TypeManager;
import org.jetbrains.annotations.NotNull;

public class Oauth2ClientImpl
implements Oauth2Client {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON = "application/json";
    private static final String RESPONSE_ACCESS_TOKEN_CLAIM = "access_token";
    private final EdcHttpClient httpClient;
    private final TypeManager typeManager;

    public Oauth2ClientImpl(EdcHttpClient httpClient, TypeManager typeManager) {
        this.httpClient = httpClient;
        this.typeManager = typeManager;
    }

    public Result<TokenRepresentation> requestToken(Oauth2CredentialsRequest request) {
        return this.httpClient.execute(Oauth2ClientImpl.toRequest(request), List.of(FallbackFactories.retryWhenStatusIsNot((int)200)), this::handleResponse);
    }

    private Result<TokenRepresentation> handleResponse(Response response) {
        return (Result)this.getStringBody(response).map(it -> (Map)this.typeManager.readValue(it, Map.class)).map(it -> it.get(RESPONSE_ACCESS_TOKEN_CLAIM).toString()).map(it -> TokenRepresentation.Builder.newInstance().token(it).build());
    }

    private static Request toRequest(Oauth2CredentialsRequest request) {
        return new Request.Builder().url(request.getUrl()).addHeader(ACCEPT, APPLICATION_JSON).addHeader(CONTENT_TYPE, FORM_URLENCODED).post((RequestBody)Oauth2ClientImpl.createRequestBody(request)).build();
    }

    private static FormBody createRequestBody(Oauth2CredentialsRequest request) {
        FormBody.Builder builder = new FormBody.Builder();
        request.getParams().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Result<String> getStringBody(Response response) {
        try (ResponseBody body = response.body();){
            if (body != null) {
                Result result2 = Result.success((Object)body.string());
                return result2;
            }
            Result result = Result.failure((String)"Body is null");
            return result;
        }
        catch (IOException e) {
            return Result.failure((String)("Cannot read response body as String: " + e.getMessage()));
        }
    }
}

