/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.monitor.logger;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.edc.spi.monitor.Monitor;

public class LoggerMonitor
implements Monitor {
    private static final Logger LOGGER = Logger.getLogger(LoggerMonitor.class.getName());

    public void severe(Supplier<String> supplier, Throwable ... errors) {
        this.log(supplier, Level.SEVERE, errors);
    }

    public void severe(Map<String, Object> data) {
        data.forEach((key, value) -> LOGGER.log(Level.SEVERE, (String)key, value));
    }

    public void warning(Supplier<String> supplier, Throwable ... errors) {
        this.log(supplier, Level.WARNING, errors);
    }

    public void info(Supplier<String> supplier, Throwable ... errors) {
        this.log(supplier, Level.INFO, errors);
    }

    public void debug(Supplier<String> supplier, Throwable ... errors) {
        this.log(supplier, Level.FINE, errors);
    }

    private void log(Supplier<String> supplier, Level level, Throwable ... errors) {
        if (errors == null || errors.length == 0) {
            LOGGER.log(level, () -> this.sanitizeMessage(supplier));
        } else {
            Arrays.stream(errors).forEach(error -> LOGGER.log(level, this.sanitizeMessage(supplier), (Throwable)error));
        }
    }
}

