/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;

public interface ManagementApiSchema {

    @Schema(name="ContractNegotiation", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"type\": \"PROVIDER\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyId\": \"counter-party-id\",\n    \"counterPartyAddress\": \"http://counter/party/address\",\n    \"state\": \"VERIFIED\",\n    \"contractAgreementId\": \"contract:agreement:id\",\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record ContractNegotiationSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractNegotiation") String ldType, @Schema(name="@id") String id, ContractNegotiation.Type type, String protocol, String counterPartyId, String counterPartyAddress, String state, String contractAgreementId, String errorDetail, List<CallbackAddressSchema> callbackAddresses) {
        public static final String CONTRACT_NEGOTIATION_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"type\": \"PROVIDER\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyId\": \"counter-party-id\",\n    \"counterPartyAddress\": \"http://counter/party/address\",\n    \"state\": \"VERIFIED\",\n    \"contractAgreementId\": \"contract:agreement:id\",\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }

    @Schema(name="Policy", description="ODRL policy", example="{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@id\": \"0949ba30-680c-44e6-bc7d-1688cbe1847e\",\n    \"@type\": \"odrl:Set\",\n    \"permission\": {\n        \"target\": \"http://example.com/asset:9898.movie\",\n        \"action\": {\n            \"type\": \"http://www.w3.org/ns/odrl/2/use\"\n        },\n        \"constraint\": {\n            \"leftOperand\": \"https://w3id.org/edc/v0.0.1/ns/left\",\n            \"operator\": \"eq\",\n            \"rightOperand\": \"value\"\n        }\n    },\n    \"prohibition\": [],\n    \"obligation\": []\n}\n")
    public record PolicySchema() {
        public static final String POLICY_EXAMPLE = "{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@id\": \"0949ba30-680c-44e6-bc7d-1688cbe1847e\",\n    \"@type\": \"odrl:Set\",\n    \"permission\": {\n        \"target\": \"http://example.com/asset:9898.movie\",\n        \"action\": {\n            \"type\": \"http://www.w3.org/ns/odrl/2/use\"\n        },\n        \"constraint\": {\n            \"leftOperand\": \"https://w3id.org/edc/v0.0.1/ns/left\",\n            \"operator\": \"eq\",\n            \"rightOperand\": \"value\"\n        }\n    },\n    \"prohibition\": [],\n    \"obligation\": []\n}\n";
    }

    @Schema(name="Properties", additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    public record FreeFormPropertiesSchema() {
    }

    @Schema(name="DataAddress", additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    public record DataAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/DataAddress") String type, @Schema(name="type") String typeProperty) {
        public static final String DATA_ADDRESS_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/DataAddress\",\n    \"type\": \"HttpData\",\n    \"baseUrl\": \"http://example.com\"\n}\n";
    }

    @Schema(name="CallbackAddress")
    public record CallbackAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/CallbackAddress") String type, String uri, Set<String> events, boolean transactional, String authKey, String authCodeId) {
    }

    @Schema(name="ContractAgreement", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractAgreement\",\n    \"@id\": \"negotiation-id\",\n    \"providerId\": \"provider-id\",\n    \"consumerId\": \"consumer-id\",\n    \"assetId\": \"asset-id\",\n    \"contractSigningDate\": 1688465655,\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"Set\",\n        \"@id\": \"offer-id\",\n        \"permission\": [{\n            \"target\": \"asset-id\",\n            \"action\": \"display\"\n        }]\n    }\n}\n")
    public record ContractAgreementSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractAgreement") String ldType, @Schema(name="@id") String id, String providerId, String consumerId, long contractSigningDate, String assetId, PolicySchema policy) {
        public static final String CONTRACT_AGREEMENT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractAgreement\",\n    \"@id\": \"negotiation-id\",\n    \"providerId\": \"provider-id\",\n    \"consumerId\": \"consumer-id\",\n    \"assetId\": \"asset-id\",\n    \"contractSigningDate\": 1688465655,\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"Set\",\n        \"@id\": \"offer-id\",\n        \"permission\": [{\n            \"target\": \"asset-id\",\n            \"action\": \"display\"\n        }]\n    }\n}\n";
    }
}

