/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.api.auth.spi.AuthenticationRequestFilter;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.connector.api.management.configuration.transform.JsonObjectFromContractAgreementTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromDataAddressTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToDataAddressTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.OdrlTransformersFactory;
import org.eclipse.edc.core.transform.transformer.odrl.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.agent.ParticipantIdMapper;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.jersey.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Provides(value={ManagementApiConfiguration.class})
@Extension(value="Management API configuration")
public class ManagementApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Management API configuration";
    public static final String WEB_SERVICE_NAME = "Management API";
    private static final String MANAGEMENT_CONTEXT_ALIAS = "management";
    private static final int DEFAULT_MANAGEMENT_API_PORT = 8181;
    private static final String DEFAULT_MANAGEMENT_API_CONTEXT_PATH = "/api/v1/management";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.management").contextAlias("management").defaultPath("/api/v1/management").defaultPort(8181).useDefaultContext(true).name("Management API").build();
    private static final String MANAGEMENT_SCOPE = "MANAGEMENT_API";
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private ParticipantIdMapper participantIdMapper;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration webServiceConfiguration = this.configurator.configure(context, this.webServer, SETTINGS);
        context.registerService(ManagementApiConfiguration.class, (Object)new ManagementApiConfiguration(webServiceConfiguration));
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new AuthenticationRequestFilter(this.authenticationService));
        this.jsonLd.registerNamespace("odrl", "http://www.w3.org/ns/odrl/2/", MANAGEMENT_SCOPE);
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, MANAGEMENT_SCOPE));
        TypeTransformerRegistry managementApiTransformerRegistry = this.transformerRegistry.forContext("management-api");
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromAssetTransformer(factory, jsonLdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(factory, this.participantIdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(factory, jsonLdMapper));
        OdrlTransformersFactory.jsonObjectToOdrlTransformers((ParticipantIdMapper)this.participantIdMapper).forEach(arg_0 -> ((TypeTransformerRegistry)managementApiTransformerRegistry).register(arg_0));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(jsonLdMapper));
    }
}

