/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

public interface ManagementApiSchema {

    @Schema(name="Policy", description="ODRL policy", example="{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@id\": \"0949ba30-680c-44e6-bc7d-1688cbe1847e\",\n    \"@type\": \"odrl:Set\",\n    \"permission\": {\n        \"target\": \"http://example.com/asset:9898.movie\",\n        \"action\": {\n            \"type\": \"http://www.w3.org/ns/odrl/2/use\"\n        },\n        \"constraint\": {\n            \"leftOperand\": \"https://w3id.org/edc/v0.0.1/ns/left\",\n            \"operator\": \"eq\",\n            \"rightOperand\": \"value\"\n        }\n    },\n    \"prohibition\": [],\n    \"obligation\": []\n}\n")
    public record PolicySchema() {
        public static final String POLICY_EXAMPLE = "{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@id\": \"0949ba30-680c-44e6-bc7d-1688cbe1847e\",\n    \"@type\": \"odrl:Set\",\n    \"permission\": {\n        \"target\": \"http://example.com/asset:9898.movie\",\n        \"action\": {\n            \"type\": \"http://www.w3.org/ns/odrl/2/use\"\n        },\n        \"constraint\": {\n            \"leftOperand\": \"https://w3id.org/edc/v0.0.1/ns/left\",\n            \"operator\": \"eq\",\n            \"rightOperand\": \"value\"\n        }\n    },\n    \"prohibition\": [],\n    \"obligation\": []\n}\n";
    }

    @Schema(name="DataAddress")
    public record DataAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/DataAddress") String type, @Schema(name="type") String typeProperty) {
    }

    @Schema(name="CallbackAddress")
    public record CallbackAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/CallbackAddress") String type, String uri, Set<String> events, boolean transactional, String authKey, String authCodeId) {
    }

    @Schema(name="ContractAgreement", example="{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractAgreement\",\n    \"@id\": \"negotiation-id\",\n    \"providerId\": \"provider-id\",\n    \"consumerId\": \"consumer-id\",\n    \"assetId\": \"asset-id\",\n    \"contractSigningDate\": 1688465655,\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"Set\",\n        \"@id\": \"offer-id\",\n        \"permission\": [{\n            \"target\": \"asset-id\",\n            \"action\": \"display\"\n        }]\n    }\n}\n")
    public record ContractAgreementSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractAgreement") String ldType, @Schema(name="@id") String id, String providerId, String consumerId, long contractSigningDate, String assetId, PolicySchema policy) {
        public static final String CONTRACT_AGREEMENT_EXAMPLE = "{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractAgreement\",\n    \"@id\": \"negotiation-id\",\n    \"providerId\": \"provider-id\",\n    \"consumerId\": \"consumer-id\",\n    \"assetId\": \"asset-id\",\n    \"contractSigningDate\": 1688465655,\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"Set\",\n        \"@id\": \"offer-id\",\n        \"permission\": [{\n            \"target\": \"asset-id\",\n            \"action\": \"display\"\n        }]\n    }\n}\n";
    }
}

