/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration.transform;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractAgreementTransformer
extends AbstractJsonLdTransformer<ContractAgreement, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractAgreementTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractAgreement.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractAgreement agreement, @NotNull TransformerContext context) {
        return this.jsonFactory.createObjectBuilder().add("@type", "https://w3id.org/edc/v0.0.1/ns/ContractAgreement").add("@id", agreement.getId()).add("https://w3id.org/edc/v0.0.1/ns/assetId", agreement.getAssetId()).add("https://w3id.org/edc/v0.0.1/ns/policy", (JsonValue)context.transform((Object)agreement.getPolicy(), JsonObject.class)).add("https://w3id.org/edc/v0.0.1/ns/contractSigningDate", agreement.getContractSigningDate()).add("https://w3id.org/edc/v0.0.1/ns/consumerId", agreement.getConsumerId()).add("https://w3id.org/edc/v0.0.1/ns/providerId", agreement.getProviderId()).build();
    }
}

