/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.api.auth.spi.AuthenticationRequestFilter;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationRegistry;
import org.eclipse.edc.connector.api.management.configuration.transform.JsonObjectFromContractAgreementTransformer;
import org.eclipse.edc.connector.controlplane.transform.edc.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.edc.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.odrl.OdrlTransformersFactory;
import org.eclipse.edc.connector.controlplane.transform.odrl.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.participant.spi.ParticipantIdMapper;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromDataAddressTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToDataAddressTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.providers.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.PortMapping;
import org.eclipse.edc.web.spi.configuration.PortMappingRegistry;
import org.eclipse.edc.web.spi.configuration.context.ManagementApiUrl;

@Provides(value={ManagementApiUrl.class})
@Extension(value="Management API configuration")
public class ManagementApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Management API configuration";
    static final String MANAGEMENT_SCOPE = "MANAGEMENT_API";
    static final int DEFAULT_MANAGEMENT_PORT = 8181;
    static final String DEFAULT_MANAGEMENT_PATH = "/api/management";
    private static final String API_VERSION_JSON_FILE = "management-api-version.json";
    private static final boolean DEFAULT_MANAGEMENT_API_ENABLE_CONTEXT = false;
    @Setting(description="Configures endpoint for reaching the Management API, in the format \"<hostname:management.port/management.path>\"", key="edc.management.endpoint", required=false)
    private String managementApiEndpoint;
    @Setting(description="If set enable the usage of management api JSON-LD context.", defaultValue="false", key="edc.management.context.enabled")
    private boolean managementApiContextEnabled;
    @Configuration
    private ManagementApiConfiguration apiConfiguration;
    @Inject
    private WebService webService;
    @Inject
    private ApiAuthenticationRegistry authenticationRegistry;
    @Inject
    private PortMappingRegistry portMappingRegistry;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private ParticipantIdMapper participantIdMapper;
    @Inject
    private Hostname hostname;
    @Inject
    private ApiVersionService apiVersionService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        PortMapping portMapping = new PortMapping("management", this.apiConfiguration.port(), this.apiConfiguration.path());
        this.portMappingRegistry.register(portMapping);
        context.registerService(ManagementApiUrl.class, (Object)this.managementApiUrl(context, portMapping));
        AuthenticationRequestFilter authenticationFilter = new AuthenticationRequestFilter(this.authenticationRegistry, "management-api");
        this.webService.registerResource("management", (Object)authenticationFilter);
        if (this.managementApiContextEnabled) {
            this.jsonLd.registerContext("https://w3id.org/edc/connector/management/v0.0.1", MANAGEMENT_SCOPE);
        } else {
            this.jsonLd.registerNamespace("@vocab", "https://w3id.org/edc/v0.0.1/ns/", MANAGEMENT_SCOPE);
            this.jsonLd.registerNamespace("edc", "https://w3id.org/edc/v0.0.1/ns/", MANAGEMENT_SCOPE);
            this.jsonLd.registerNamespace("odrl", "http://www.w3.org/ns/odrl/2/", MANAGEMENT_SCOPE);
        }
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.webService.registerResource("management", (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource("management", (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, MANAGEMENT_SCOPE));
        TypeTransformerRegistry managementApiTransformerRegistry = this.transformerRegistry.forContext("management-api");
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromAssetTransformer(factory, jsonLdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(factory, this.participantIdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(factory, jsonLdMapper));
        OdrlTransformersFactory.jsonObjectToOdrlTransformers((ParticipantIdMapper)this.participantIdMapper).forEach(arg_0 -> ((TypeTransformerRegistry)managementApiTransformerRegistry).register(arg_0));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(jsonLdMapper));
        TypeTransformerRegistry managementApiTransformerRegistryV4Alpha = managementApiTransformerRegistry.forContext("v4alpha");
        managementApiTransformerRegistryV4Alpha.register((TypeTransformer)new JsonObjectFromPolicyTransformer(factory, this.participantIdMapper, true));
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("management", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    private ManagementApiUrl managementApiUrl(ServiceExtensionContext context, PortMapping config) {
        String callbackAddress = Optional.ofNullable(this.managementApiEndpoint).orElseGet(() -> String.format("http://%s:%s%s", this.hostname.get(), config.port(), config.path()));
        try {
            URI url = URI.create(callbackAddress);
            return () -> url;
        }
        catch (IllegalArgumentException e) {
            context.getMonitor().severe("Error creating management plane endpoint url", new Throwable[]{e});
            throw new EdcException((Throwable)e);
        }
    }

    @Settings
    record ManagementApiConfiguration(@Setting(key="web.http.management.port", description="Port for management api context", defaultValue="8181") int port, @Setting(key="web.http.management.path", description="Path for management api context", defaultValue="/api/management") String path) {
    }
}

