/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.edc.api.auth.spi.AuthenticationRequestFilter;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationRegistry;
import org.eclipse.edc.connector.api.management.configuration.transform.JsonObjectFromContractAgreementTransformer;
import org.eclipse.edc.connector.controlplane.transform.edc.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.edc.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.odrl.OdrlTransformersFactory;
import org.eclipse.edc.connector.controlplane.transform.odrl.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.participant.spi.ParticipantIdMapper;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.SettingContext;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromDataAddressTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToDataAddressTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.providers.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;
import org.eclipse.edc.web.spi.configuration.context.ManagementApiUrl;

@Provides(value={ManagementApiUrl.class})
@Extension(value="Management API configuration")
public class ManagementApiConfigurationExtension
implements ServiceExtension {
    public static final String API_VERSION_JSON_FILE = "management-api-version.json";
    public static final String NAME = "Management API configuration";
    public static final String WEB_SERVICE_NAME = "Management API";
    public static final String MANAGEMENT_SCOPE = "MANAGEMENT_API";
    @SettingContext(value="Management API context setting key")
    private static final String MANAGEMENT_CONFIG_KEY = "web.http.management";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.management").contextAlias("management").defaultPath("/api/v1/management").defaultPort(8181).useDefaultContext(true).name("Management API").build();
    @Setting(value="Configures endpoint for reaching the Management API.", defaultValue="<hostname:management.port/management.path>")
    private static final String MANAGEMENT_API_ENDPOINT = "edc.management.endpoint";
    private static final boolean DEFAULT_MANAGEMENT_API_ENABLE_CONTEXT = false;
    @Setting(value="If set enable the usage of management api JSON-LD context.", defaultValue="false")
    private static final String MANAGEMENT_API_ENABLE_CONTEXT = "edc.management.context.enabled";
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private ApiAuthenticationRegistry authenticationRegistry;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private ParticipantIdMapper participantIdMapper;
    @Inject
    private Hostname hostname;
    @Inject
    private ApiVersionService apiVersionService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Config config = context.getConfig(MANAGEMENT_CONFIG_KEY);
        WebServiceConfiguration webServiceConfiguration = this.configurator.configure(config, this.webServer, SETTINGS);
        context.registerService(ManagementApiUrl.class, (Object)this.managementApiUrl(context, webServiceConfiguration));
        AuthenticationRequestFilter authenticationFilter = new AuthenticationRequestFilter(this.authenticationRegistry, "management-api");
        this.webService.registerResource("management", (Object)authenticationFilter);
        boolean isManagementContextEnabled = context.getSetting(MANAGEMENT_API_ENABLE_CONTEXT, false);
        if (isManagementContextEnabled) {
            this.jsonLd.registerContext("https://w3id.org/edc/connector/management/v0.0.1", MANAGEMENT_SCOPE);
        } else {
            this.jsonLd.registerNamespace("@vocab", "https://w3id.org/edc/v0.0.1/ns/", MANAGEMENT_SCOPE);
            this.jsonLd.registerNamespace("edc", "https://w3id.org/edc/v0.0.1/ns/", MANAGEMENT_SCOPE);
            this.jsonLd.registerNamespace("odrl", "http://www.w3.org/ns/odrl/2/", MANAGEMENT_SCOPE);
        }
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.webService.registerResource("management", (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource("management", (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, MANAGEMENT_SCOPE));
        TypeTransformerRegistry managementApiTransformerRegistry = this.transformerRegistry.forContext("management-api");
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromAssetTransformer(factory, jsonLdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(factory, this.participantIdMapper));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(factory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(factory, jsonLdMapper));
        OdrlTransformersFactory.jsonObjectToOdrlTransformers((ParticipantIdMapper)this.participantIdMapper).forEach(arg_0 -> ((TypeTransformerRegistry)managementApiTransformerRegistry).register(arg_0));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(jsonLdMapper));
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("management", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    private ManagementApiUrl managementApiUrl(ServiceExtensionContext context, WebServiceConfiguration config) {
        String callbackAddress = context.getSetting(MANAGEMENT_API_ENDPOINT, String.format("http://%s:%s%s", this.hostname.get(), config.getPort(), config.getPath()));
        try {
            URI url = URI.create(callbackAddress);
            return () -> url;
        }
        catch (IllegalArgumentException e) {
            context.getMonitor().severe("Error creating management plane endpoint url", new Throwable[]{e});
            throw new EdcException((Throwable)e);
        }
    }
}

