/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import org.eclipse.edc.api.auth.spi.AuthenticationRequestFilter;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Provides(value={ManagementApiConfiguration.class})
@Extension(value="Management API configuration")
public class ManagementApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Management API configuration";
    private static final String DEPRECATED_MANAGEMENT_SETTINGS_GROUP_SUFFIX = "data";
    private static final String DATA_MANAGEMENT_CONTEXT_ALIAS = "management";
    private static final int DEFAULT_DATA_MANAGEMENT_API_PORT = 8181;
    private static final String DEPRECATED_DEFAULT_DATA_MANAGEMENT_API_CONTEXT_PATH = "/api";
    private static final String DEFAULT_DATA_MANAGEMENT_API_CONTEXT_PATH = "/api/v1/management";
    public static final String WEB_SERVICE_NAME = "Management API";
    @Deprecated(since="milestone8")
    public static final WebServiceSettings DEPRECATED_SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.data").contextAlias("management").defaultPath("/api").defaultPort(8181).useDefaultContext(true).name("Management API").build();
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.management").contextAlias("management").defaultPath("/api/v1/management").defaultPort(8181).useDefaultContext(true).name("Management API").build();
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private WebServiceConfigurer configurator;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceSettings settings;
        Config config = context.getConfig();
        if (config.hasPath(DEPRECATED_SETTINGS.apiConfigKey()) && !config.hasPath(SETTINGS.apiConfigKey())) {
            settings = DEPRECATED_SETTINGS;
            context.getMonitor().warning(String.format("Deprecated settings group %s is being used for Management API configuration, please switch to the new group %s", DEPRECATED_SETTINGS.apiConfigKey(), SETTINGS.apiConfigKey()), new Throwable[0]);
        } else {
            settings = SETTINGS;
        }
        WebServiceConfiguration webServiceConfiguration = this.configurator.configure(context, this.webServer, settings);
        context.registerService(ManagementApiConfiguration.class, (Object)new ManagementApiConfiguration(webServiceConfiguration));
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new AuthenticationRequestFilter(this.authenticationService));
    }
}

