/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.linkeddata;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.Term;
import com.apicatalog.ld.node.LdNode;
import com.apicatalog.ld.node.LdType;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.vc.Presentation;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.method.resolver.HttpMethodResolver;
import com.apicatalog.vc.method.resolver.MethodResolver;
import com.apicatalog.vc.proof.EmbeddedProof;
import com.apicatalog.vc.proof.Proof;
import com.apicatalog.vc.proof.ProofValue;
import com.apicatalog.vc.suite.SignatureSuite;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.iam.identitytrust.spi.verification.CredentialVerifier;
import org.eclipse.edc.iam.identitytrust.spi.verification.SignatureSuiteRegistry;
import org.eclipse.edc.iam.identitytrust.spi.verification.VerifierContext;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.util.uri.UriUtils;

public class LdpVerifier
implements CredentialVerifier {
    private JsonLd jsonLd;
    private ObjectMapper jsonLdMapper;
    private SignatureSuiteRegistry suiteRegistry;
    private Map<String, Object> params;
    private Collection<MethodResolver> methodResolvers = new ArrayList<HttpMethodResolver>(List.of(new HttpMethodResolver()));
    private DocumentLoader loader;
    private URI base;

    private LdpVerifier() {
    }

    public boolean canHandle(String rawInput) {
        boolean bl;
        block8: {
            JsonParser parser = this.jsonLdMapper.createParser(rawInput);
            try {
                parser.nextToken();
                bl = true;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            parser.close();
        }
        return bl;
    }

    public Result<Void> verify(String rawInput, VerifierContext verifierContext) {
        JsonObject jo;
        try {
            jo = (JsonObject)this.jsonLdMapper.readValue(rawInput, JsonObject.class);
        }
        catch (JsonProcessingException e) {
            return Result.failure((String)"Failed to parse JSON: %s".formatted(e.toString()));
        }
        JsonArray context = jo.containsKey((Object)"@context") ? JsonUtils.toJsonArray((JsonValue)((JsonValue)jo.get((Object)"@context"))) : null;
        Result expansion = this.jsonLd.expand(jo);
        if (this.loader == null) {
            this.loader = SchemeRouter.defaultInstance();
        }
        return (Result)expansion.compose(expandedDocument -> {
            try {
                return this.verifyExpanded((JsonObject)expandedDocument, verifierContext, (JsonStructure)context);
            }
            catch (DocumentError e) {
                return Result.failure((String)"Could not verify VP-LDP: message: %s, code: %s".formatted(e.getMessage(), e.getCode()));
            }
            catch (VerificationError e) {
                return Result.failure((String)"Could not verify VP-LDP: %s | message: %s".formatted(e.getCode(), e.getMessage()));
            }
        });
    }

    public URI getBase() {
        return this.base;
    }

    private VerificationMethod resolveMethod(URI id, Proof proof, DocumentLoader loader) throws DocumentError {
        if (id == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofVerificationId");
        }
        Optional<MethodResolver> resolver = this.methodResolvers.stream().filter(r -> r.isAccepted(id)).findFirst();
        if (resolver.isPresent()) {
            return resolver.get().resolve(id, loader, proof);
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, "ProofVerificationId");
    }

    private Result<Void> validateCredentialIssuer(JsonObject expanded, VerificationMethod verificationMethod) {
        try {
            LdNode issuerUri = LdNode.of((JsonObject)expanded).node(VcVocab.ISSUER);
            if (!issuerUri.exists()) {
                return Result.failure((String)"Document must contain an 'issuer' property.");
            }
            if (!UriUtils.equalsIgnoreFragment((URI)issuerUri.id(), (URI)verificationMethod.id())) {
                return Result.failure((String)"Issuer and proof.verificationMethod mismatch: %s <> %s".formatted(issuerUri, verificationMethod.id()));
            }
        }
        catch (DocumentError e) {
            return Result.failure((String)"Error getting issuer: %s".formatted(e.getMessage()));
        }
        return Result.success();
    }

    private Result<Void> verifyExpanded(JsonObject expanded, VerifierContext context, JsonStructure ldContext) throws VerificationError, DocumentError {
        if (this.isCredential(expanded)) {
            return this.verifyProofs(expanded, ldContext);
        }
        if (this.isPresentation(expanded)) {
            Result<Void> presentationValidation = this.verifyProofs(expanded, ldContext);
            if (!presentationValidation.succeeded()) {
                return presentationValidation.mapTo();
            }
            ArrayList<JsonObject> credentials = new ArrayList<JsonObject>();
            for (JsonObject credential : Presentation.getCredentials((JsonObject)expanded)) {
                if (JsonUtils.isNotObject((JsonValue)credential)) {
                    return Result.failure((String)"Presentation contained an invalid 'verifiableCredential' object!");
                }
                credentials.add(credential.asJsonObject());
            }
            return credentials.stream().map(expCred -> context.verify(expCred.toString())).reduce(Result::merge).orElse(Result.success());
        }
        return Result.failure((String)"%s: %s".formatted(DocumentError.ErrorType.Unknown, Term.TYPE));
    }

    private Result<Void> verifyProofs(JsonObject expanded, JsonStructure context) throws VerificationError, DocumentError {
        Collection expandedProofs = EmbeddedProof.assertProof((JsonObject)expanded);
        ArrayList<Proof> allProofs = new ArrayList<Proof>(expandedProofs.size());
        JsonObject data = EmbeddedProof.removeProofs((JsonObject)expanded);
        for (JsonObject expandedProof : expandedProofs) {
            if (JsonUtils.isNotObject((JsonValue)expandedProof)) {
                return Result.failure((String)"%s: %s".formatted(DocumentError.ErrorType.Invalid, VcVocab.PROOF));
            }
            Collection proofTypes = LdType.strings((JsonObject)expandedProof);
            if (proofTypes == null || proofTypes.isEmpty()) {
                return Result.failure((String)"%s: %s, %s".formatted(DocumentError.ErrorType.Missing, VcVocab.PROOF, Term.TYPE));
            }
            SignatureSuite signatureSuite = this.findSuite(proofTypes, expandedProof);
            if (signatureSuite == null) {
                return Result.failure((String)"No SignatureSuite found for proof type(s) '%s'.".formatted(String.join((CharSequence)",", new CharSequence[0])));
            }
            Proof proof = signatureSuite.getProof(expandedProof, this.loader);
            if (proof == null) {
                return Result.failure((String)("The suite [" + signatureSuite + "] returns null as a proof."));
            }
            allProofs.add(proof);
        }
        for (Proof proof : allProofs) {
            try {
                Result<Void> failure;
                proof.validate(Map.of());
                ProofValue proofValue = proof.signature();
                if (proofValue == null) {
                    return Result.failure((String)"Proof did not contain a valid signature.");
                }
                VerificationMethod verificationMethod = this.getMethod(proof, this.loader);
                if (verificationMethod == null) {
                    return Result.failure((String)"Proof did not contain a VerificationMethod.");
                }
                if (!(verificationMethod instanceof VerificationKey)) {
                    return Result.failure((String)"Proof did not contain a valid VerificationMethod, expected VerificationKey, got: %s".formatted(verificationMethod.getClass()));
                }
                if (this.isCredential(expanded) && (failure = this.validateCredentialIssuer(expanded, verificationMethod)).failed()) {
                    return failure;
                }
                proof.verify(context, data, (VerificationKey)verificationMethod);
            }
            catch (DocumentError error) {
                return Result.failure((String)"Could not verify VP-LDP: message: %s, code: %s".formatted(error.getMessage(), error.getCode()));
            }
            catch (VerificationError error) {
                return Result.failure((String)"Verification failed: %s".formatted(error.getMessage()));
            }
        }
        return Result.success();
    }

    private VerificationMethod getMethod(Proof proof, DocumentLoader loader) throws DocumentError {
        VerificationMethod method = proof.method();
        if (method == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, "ProofVerificationMethod");
        }
        URI methodType = method.type();
        if (methodType != null && method instanceof VerificationKey && ((VerificationKey)method).publicKey() != null) {
            return method;
        }
        return this.resolveMethod(method.id(), proof, loader);
    }

    private SignatureSuite findSuite(Collection<String> proofTypes, JsonObject expandedProof) {
        return this.suiteRegistry.getAllSuites().stream().filter(s -> proofTypes.stream().anyMatch(type -> s.isSupported(type, expandedProof))).findFirst().orElse(null);
    }

    private boolean isCredential(JsonObject expanded) {
        return LdNode.isTypeOf((String)VcVocab.CREDENTIAL_TYPE.uri(), (JsonValue)expanded);
    }

    private boolean isPresentation(JsonObject expanded) {
        return LdNode.isTypeOf((String)VcVocab.PRESENTATION_TYPE.uri(), (JsonValue)expanded);
    }

    public static class Builder {
        private final LdpVerifier verifier = new LdpVerifier();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder signatureSuites(SignatureSuiteRegistry registry) {
            this.verifier.suiteRegistry = registry;
            return this;
        }

        public Builder params(Map<String, Object> params) {
            this.verifier.params = params;
            return this;
        }

        public Builder param(String key, Object object) {
            this.verifier.params.put(key, object);
            return this;
        }

        public Builder methodResolvers(Collection<MethodResolver> resolvers) {
            this.verifier.methodResolvers = resolvers;
            return this;
        }

        public Builder methodResolver(MethodResolver resolver) {
            this.verifier.methodResolvers.add(resolver);
            return this;
        }

        public Builder objectMapper(ObjectMapper mapper) {
            this.verifier.jsonLdMapper = mapper;
            return this;
        }

        public Builder jsonLd(JsonLd jsonLd) {
            this.verifier.jsonLd = jsonLd;
            return this;
        }

        public Builder base(URI base) {
            this.verifier.base = base;
            return this;
        }

        public Builder loader(DocumentLoader loader) {
            this.verifier.loader = loader;
            return this;
        }

        public LdpVerifier build() {
            Objects.requireNonNull(this.verifier.jsonLd, "Must have a JsonLD service!");
            Objects.requireNonNull(this.verifier.jsonLdMapper, "Must have an ObjectMapper!");
            Objects.requireNonNull(this.verifier.suiteRegistry, "Must have a Signature registry!");
            return this.verifier;
        }
    }
}

