/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.linkeddata;

import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.vc.issuer.ProofDraft;
import com.apicatalog.vc.loader.StaticContextLoader;
import com.apicatalog.vc.processor.ExpandedVerifiable;
import com.apicatalog.vc.suite.SignatureSuite;
import jakarta.json.JsonObject;
import java.net.URI;
import java.util.Objects;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;

public class LdpIssuer {
    private JsonLd jsonLdService;
    private DocumentLoader loader;
    private boolean bundledContexts;
    private URI base;
    private Monitor monitor;

    private LdpIssuer() {
    }

    public Result<JsonObject> signDocument(SignatureSuite signatureSuite, JsonObject document, KeyPair keyPair, ProofDraft proofDraft) {
        Objects.requireNonNull(signatureSuite, "SignatureSuite must not be null");
        Objects.requireNonNull(document, "Document must not be null");
        Objects.requireNonNull(document, "KeyPair must not be null");
        Objects.requireNonNull(document, "ProofOptions must not be null");
        if (this.loader == null) {
            this.loader = SchemeRouter.defaultInstance();
        }
        if (this.bundledContexts) {
            this.loader = new StaticContextLoader(this.loader);
        }
        return (Result)this.jsonLdService.expand(document).compose(expanded -> this.signExpanded(signatureSuite, (JsonObject)expanded, keyPair, proofDraft));
    }

    private Result<JsonObject> signExpanded(SignatureSuite signatureSuite, JsonObject expanded, KeyPair keyPair, ProofDraft proofDraft) {
        try {
            ExpandedVerifiable signed = signatureSuite.createIssuer(keyPair).loader(this.loader).base(this.base).useBundledContexts(this.bundledContexts).sign(expanded, proofDraft);
            return Result.success((Object)signed.expanded());
        }
        catch (DocumentError | SigningError e) {
            this.monitor.warning("Error signing document", new Throwable[]{e});
            return Result.failure((String)("Error signing document: " + e.getMessage()));
        }
    }

    public static final class Builder {
        private final LdpIssuer ldpIssuer = new LdpIssuer();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder jsonLd(JsonLd jsonLd) {
            this.ldpIssuer.jsonLdService = jsonLd;
            return this;
        }

        public Builder loader(DocumentLoader loader) {
            this.ldpIssuer.loader = loader;
            return this;
        }

        public Builder bundledContexts(boolean bundledContexts) {
            this.ldpIssuer.bundledContexts = bundledContexts;
            return this;
        }

        public Builder base(URI base) {
            this.ldpIssuer.base = base;
            return this;
        }

        public Builder monitor(Monitor monitor) {
            this.ldpIssuer.monitor = monitor;
            return this;
        }

        public LdpIssuer build() {
            Objects.requireNonNull(this.ldpIssuer.jsonLdService, "Must have a JsonLd instance");
            Objects.requireNonNull(this.ldpIssuer.monitor, "Monitor cannot be null");
            return this.ldpIssuer;
        }
    }
}

